@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id Resource Id
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property name Resource name
 * @property provisioningState Gets the provisioning state of the Just-in-Time policy.
 * @property requests
 * @property type Resource type
 * @property virtualMachines Configurations for Microsoft.Compute/virtualMachines resource type.
 */
public data class GetJitNetworkAccessPolicyResult(
    public val id: String,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val requests: List<JitNetworkAccessRequestResponse>? = null,
    public val type: String,
    public val virtualMachines: List<JitNetworkAccessPolicyVirtualMachineResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetJitNetworkAccessPolicyResult): GetJitNetworkAccessPolicyResult = GetJitNetworkAccessPolicyResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            requests = javaType.requests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessRequestResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessPolicyVirtualMachineResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
