@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The security connector resource.
 * @property environmentData The security connector environment data.
 * @property environmentName The multi cloud resource's cloud name.
 * @property etag Entity tag is used for comparing two or more entities from the same requested resource.
 * @property hierarchyIdentifier The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
 * @property hierarchyIdentifierTrialEndDate The date on which the trial period will end, if applicable. Trial period exists for 30 days after upgrading to payed offerings.
 * @property id Resource Id
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property name Resource name
 * @property offerings A collection of offerings for the security connector.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags A list of key value pairs that describe the resource.
 * @property type Resource type
 */
public data class GetSecurityConnectorResult(
    public val environmentData: Any? = null,
    public val environmentName: String? = null,
    public val etag: String? = null,
    public val hierarchyIdentifier: String? = null,
    public val hierarchyIdentifierTrialEndDate: String,
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String,
    public val offerings: List<Any>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetSecurityConnectorResult): GetSecurityConnectorResult = GetSecurityConnectorResult(
            environmentData = javaType.environmentData().map({ args0 -> args0 }).orElse(null),
            environmentName = javaType.environmentName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            hierarchyIdentifier = javaType.hierarchyIdentifier().map({ args0 -> args0 }).orElse(null),
            hierarchyIdentifierTrialEndDate = javaType.hierarchyIdentifierTrialEndDate(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            offerings = javaType.offerings().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
