@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Security operator under a given subscription and pricing
 * @property id Resource Id
 * @property identity Identity for the resource.
 * @property name Resource name
 * @property type Resource type
 */
public data class GetSecurityOperatorResult(
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetSecurityOperatorResult): GetSecurityOperatorResult = GetSecurityOperatorResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
