@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the server vulnerability assessment details on a resource
 * @property id Resource Id
 * @property name Resource name
 * @property provisioningState The provisioningState of the vulnerability assessment capability on the VM
 * @property type Resource type
 */
public data class GetServerVulnerabilityAssessmentResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetServerVulnerabilityAssessmentResult): GetServerVulnerabilityAssessmentResult = GetServerVulnerabilityAssessmentResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
