@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configures where to store the OMS agent data for workspaces under a scope
 * @property id Resource Id
 * @property name Resource name
 * @property scope All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
 * @property type Resource type
 * @property workspaceId The full Azure ID of the workspace to save the data in
 */
public data class GetWorkspaceSettingResult(
    public val id: String,
    public val name: String,
    public val scope: String,
    public val type: String,
    public val workspaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetWorkspaceSettingResult): GetWorkspaceSettingResult = GetWorkspaceSettingResult(
            id = javaType.id(),
            name = javaType.name(),
            scope = javaType.scope(),
            type = javaType.type(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
