@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The GitLab scope connector's environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'GitlabScope'.
 */
public data class GitlabScopeEnvironmentDataResponse(
    public val environmentType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GitlabScopeEnvironmentDataResponse): GitlabScopeEnvironmentDataResponse = GitlabScopeEnvironmentDataResponse(
            environmentType = javaType.environmentType(),
        )
    }
}
