@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describe the additional data of governance assignment - optional
 * @property ticketLink Ticket link associated with this governance assignment - for example: https://snow.com
 * @property ticketNumber Ticket number associated with this governance assignment
 * @property ticketStatus The ticket status associated with this governance assignment - for example: Active
 */
public data class GovernanceAssignmentAdditionalDataResponse(
    public val ticketLink: String? = null,
    public val ticketNumber: Int? = null,
    public val ticketStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GovernanceAssignmentAdditionalDataResponse): GovernanceAssignmentAdditionalDataResponse = GovernanceAssignmentAdditionalDataResponse(
            ticketLink = javaType.ticketLink().map({ args0 -> args0 }).orElse(null),
            ticketNumber = javaType.ticketNumber().map({ args0 -> args0 }).orElse(null),
            ticketStatus = javaType.ticketStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
