@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The governance email weekly notification configuration.
 * @property disableManagerEmailNotification Exclude manager from weekly email notification.
 * @property disableOwnerEmailNotification Exclude  owner from weekly email notification.
 */
public data class GovernanceEmailNotificationResponse(
    public val disableManagerEmailNotification: Boolean? = null,
    public val disableOwnerEmailNotification: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GovernanceEmailNotificationResponse): GovernanceEmailNotificationResponse = GovernanceEmailNotificationResponse(
            disableManagerEmailNotification = javaType.disableManagerEmailNotification().map({ args0 ->
                args0
            }).orElse(null),
            disableOwnerEmailNotification = javaType.disableOwnerEmailNotification().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
