@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describe the owner source of governance rule
 * @property type The owner type for the governance rule owner source
 * @property value The source value e.g. tag key like owner name or email address
 */
public data class GovernanceRuleOwnerSourceResponse(
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GovernanceRuleOwnerSourceResponse): GovernanceRuleOwnerSourceResponse = GovernanceRuleOwnerSourceResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
