@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings for hybrid compute management
 * @property autoProvision Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
 * @property hybridComputeProvisioningState State of the service principal and its secret
 * @property proxyServer For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
 * @property region The location where the metadata of machines will be stored
 * @property resourceGroupName The name of the resource group where Arc (Hybrid Compute) connectors are connected.
 * @property servicePrincipal An object to access resources that are secured by an Azure AD tenant.
 */
public data class HybridComputeSettingsPropertiesResponse(
    public val autoProvision: String,
    public val hybridComputeProvisioningState: String,
    public val proxyServer: ProxyServerPropertiesResponse? = null,
    public val region: String? = null,
    public val resourceGroupName: String? = null,
    public val servicePrincipal: ServicePrincipalPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.HybridComputeSettingsPropertiesResponse): HybridComputeSettingsPropertiesResponse = HybridComputeSettingsPropertiesResponse(
            autoProvision = javaType.autoProvision(),
            hybridComputeProvisioningState = javaType.hybridComputeProvisioningState(),
            proxyServer = javaType.proxyServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.ProxyServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            servicePrincipal = javaType.servicePrincipal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.ServicePrincipalPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
