@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The information protection for AWS offering
 * @property description The offering description.
 * @property informationProtection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'InformationProtectionAws'.
 */
public data class InformationProtectionAwsOfferingResponse(
    public val description: String,
    public val informationProtection: InformationProtectionAwsOfferingResponseInformationProtection? =
        null,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.InformationProtectionAwsOfferingResponse): InformationProtectionAwsOfferingResponse = InformationProtectionAwsOfferingResponse(
            description = javaType.description(),
            informationProtection = javaType.informationProtection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.InformationProtectionAwsOfferingResponseInformationProtection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
        )
    }
}
