@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id Resource ID of the virtual machine that is linked to this policy
 * @property ports Port configurations for the virtual machine
 * @property publicIpAddress Public IP address of the Azure Firewall that is linked to this policy, if applicable
 */
public data class JitNetworkAccessPolicyVirtualMachineResponse(
    public val id: String,
    public val ports: List<JitNetworkAccessPortRuleResponse>,
    public val publicIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.JitNetworkAccessPolicyVirtualMachineResponse): JitNetworkAccessPolicyVirtualMachineResponse = JitNetworkAccessPolicyVirtualMachineResponse(
            id = javaType.id(),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessPortRuleResponse.Companion.toKotlin(args0)
                })
            }),
            publicIpAddress = javaType.publicIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
