@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedSourceAddressPrefix Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
 * @property allowedSourceAddressPrefixes Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
 * @property maxRequestAccessDuration Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
 * @property number
 * @property protocol
 */
public data class JitNetworkAccessPortRuleResponse(
    public val allowedSourceAddressPrefix: String? = null,
    public val allowedSourceAddressPrefixes: List<String>? = null,
    public val maxRequestAccessDuration: String,
    public val number: Int,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.JitNetworkAccessPortRuleResponse): JitNetworkAccessPortRuleResponse = JitNetworkAccessPortRuleResponse(
            allowedSourceAddressPrefix = javaType.allowedSourceAddressPrefix().map({ args0 ->
                args0
            }).orElse(null),
            allowedSourceAddressPrefixes = javaType.allowedSourceAddressPrefixes().map({ args0 -> args0 }),
            maxRequestAccessDuration = javaType.maxRequestAccessDuration(),
            number = javaType.number(),
            protocol = javaType.protocol(),
        )
    }
}
