@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property justification The justification for making the initiate request
 * @property requestor The identity of the person who made the request
 * @property startTimeUtc The start time of the request in UTC
 * @property virtualMachines
 */
public data class JitNetworkAccessRequestResponse(
    public val justification: String? = null,
    public val requestor: String,
    public val startTimeUtc: String,
    public val virtualMachines: List<JitNetworkAccessRequestVirtualMachineResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.JitNetworkAccessRequestResponse): JitNetworkAccessRequestResponse = JitNetworkAccessRequestResponse(
            justification = javaType.justification().map({ args0 -> args0 }).orElse(null),
            requestor = javaType.requestor(),
            startTimeUtc = javaType.startTimeUtc(),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessRequestVirtualMachineResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
