@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of RP resources which supports pagination.
 * @property nextLink Gets or sets next link to scroll over the results.
 * @property value Gets or sets list of resources.
 */
public data class ListGitLabGroupAvailableResult(
    public val nextLink: String? = null,
    public val `value`: List<GitLabGroupResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ListGitLabGroupAvailableResult): ListGitLabGroupAvailableResult = ListGitLabGroupAvailableResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.GitLabGroupResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
