@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of Malware Scanning.
 * @property capGBPerMonth Defines the max GB to be scanned per Month. Set to -1 if no capping is needed.
 * @property isEnabled Indicates whether On Upload malware scanning should be enabled.
 * @property operationStatus Upon failure or partial success. Additional data describing Malware Scanning enable/disable operation.
 * @property scanResultsEventGridTopicResourceId Optional. Resource id of an Event Grid Topic to send scan results to.
 */
public data class MalwareScanningPropertiesResponse(
    public val capGBPerMonth: Int? = null,
    public val isEnabled: Boolean? = null,
    public val operationStatus: OperationStatusResponse,
    public val scanResultsEventGridTopicResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.MalwareScanningPropertiesResponse): MalwareScanningPropertiesResponse = MalwareScanningPropertiesResponse(
            capGBPerMonth = javaType.capGBPerMonth().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            operationStatus = javaType.operationStatus().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.OperationStatusResponse.Companion.toKotlin(args0)
            }),
            scanResultsEventGridTopicResourceId = javaType.scanResultsEventGridTopicResourceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
