@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the On Premise Sql resource that was assessed
 * @property databaseName The Sql database name installed on the machine
 * @property machineName The name of the machine
 * @property serverName The Sql server name installed on the machine
 * @property source The platform where the assessed resource resides
 * Expected value is 'OnPremiseSql'.
 * @property sourceComputerId The oms agent Id installed on the machine
 * @property vmuuid The unique Id of the machine
 * @property workspaceId Azure resource Id of the workspace the machine is attached to
 */
public data class OnPremiseSqlResourceDetailsResponse(
    public val databaseName: String,
    public val machineName: String,
    public val serverName: String,
    public val source: String,
    public val sourceComputerId: String,
    public val vmuuid: String,
    public val workspaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.OnPremiseSqlResourceDetailsResponse): OnPremiseSqlResourceDetailsResponse = OnPremiseSqlResourceDetailsResponse(
            databaseName = javaType.databaseName(),
            machineName = javaType.machineName(),
            serverName = javaType.serverName(),
            source = javaType.source(),
            sourceComputerId = javaType.sourceComputerId(),
            vmuuid = javaType.vmuuid(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
