@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A status describing the success/failure of the extension's enablement/disablement operation.
 * @property code The operation status code.
 * @property message Additional information regarding the success/failure of the operation.
 */
public data class OperationStatusResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.OperationStatusResponse): OperationStatusResponse = OperationStatusResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
