@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
 * @property exe The application control policy enforcement/protection mode of the machine group
 * @property executable The application control policy enforcement/protection mode of the machine group
 * @property msi The application control policy enforcement/protection mode of the machine group
 * @property script The application control policy enforcement/protection mode of the machine group
 */
public data class ProtectionModeResponse(
    public val exe: String? = null,
    public val executable: String? = null,
    public val msi: String? = null,
    public val script: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ProtectionModeResponse): ProtectionModeResponse = ProtectionModeResponse(
            exe = javaType.exe().map({ args0 -> args0 }).orElse(null),
            executable = javaType.executable().map({ args0 -> args0 }).orElse(null),
            msi = javaType.msi().map({ args0 -> args0 }).orElse(null),
            script = javaType.script().map({ args0 -> args0 }).orElse(null),
        )
    }
}
