@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
 * @property ip Proxy server IP
 * @property port Proxy server port
 */
public data class ProxyServerPropertiesResponse(
    public val ip: String? = null,
    public val port: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ProxyServerPropertiesResponse): ProxyServerPropertiesResponse = ProxyServerPropertiesResponse(
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
