@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the publisher information of a process/rule
 * @property binaryName The "OriginalName" field taken from the file's version resource
 * @property productName The product name taken from the file's version resource
 * @property publisherName The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
 * @property version The binary file version taken from the file's version resource
 */
public data class PublisherInfoResponse(
    public val binaryName: String? = null,
    public val productName: String? = null,
    public val publisherName: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.PublisherInfoResponse): PublisherInfoResponse = PublisherInfoResponse(
            binaryName = javaType.binaryName().map({ args0 -> args0 }).orElse(null),
            productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
            publisherName = javaType.publisherName().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
