@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the partner that created the assessment
 * @property partnerName Name of the company of the partner
 * @property productName Name of the product of the partner that created the assessment
 * @property secret Secret to authenticate the partner and verify it created the assessment - write only
 */
public data class SecurityAssessmentMetadataPartnerDataResponse(
    public val partnerName: String,
    public val productName: String? = null,
    public val secret: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.SecurityAssessmentMetadataPartnerDataResponse): SecurityAssessmentMetadataPartnerDataResponse =
            SecurityAssessmentMetadataPartnerDataResponse(
                partnerName = javaType.partnerName(),
                productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
                secret = javaType.secret(),
            )
    }
}
