@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data regarding 3rd party partner integration
 * @property partnerName Name of the company of the partner
 * @property secret secret to authenticate the partner - write only
 */
public data class SecurityAssessmentPartnerDataResponse(
    public val partnerName: String,
    public val secret: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.SecurityAssessmentPartnerDataResponse): SecurityAssessmentPartnerDataResponse = SecurityAssessmentPartnerDataResponse(
            partnerName = javaType.partnerName(),
            secret = javaType.secret(),
        )
    }
}
