@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines whether to send email notifications about new security alerts
 * @property minimalSeverity Defines the minimal alert severity which will be sent as email notifications
 * @property state Defines if email notifications will be sent about new security alerts
 */
public data class SecurityContactPropertiesResponseAlertNotifications(
    public val minimalSeverity: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.SecurityContactPropertiesResponseAlertNotifications): SecurityContactPropertiesResponseAlertNotifications =
            SecurityContactPropertiesResponseAlertNotifications(
                minimalSeverity = javaType.minimalSeverity().map({ args0 -> args0 }).orElse(null),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
            )
    }
}
