@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 * @property roles Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
 * @property state Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 */
public data class SecurityContactPropertiesResponseNotificationsByRole(
    public val roles: List<String>? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.SecurityContactPropertiesResponseNotificationsByRole): SecurityContactPropertiesResponseNotificationsByRole =
            SecurityContactPropertiesResponseNotificationsByRole(
                roles = javaType.roles().map({ args0 -> args0 }),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
            )
    }
}
