@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Repository branch configuration for PR Annotations.
 * @property annotateDefaultBranch Configuration of PR Annotations on default branch.
 * Enabled - PR Annotations are enabled on the resource's default branch.
 * Disabled - PR Annotations are disabled on the resource's default branch.
 * @property branchNames Gets or sets branches that should have annotations.
 */
public data class TargetBranchConfigurationResponse(
    public val annotateDefaultBranch: String? = null,
    public val branchNames: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.TargetBranchConfigurationResponse): TargetBranchConfigurationResponse = TargetBranchConfigurationResponse(
            annotateDefaultBranch = javaType.annotateDefaultBranch().map({ args0 -> args0 }).orElse(null),
            branchNames = javaType.branchNames().map({ args0 -> args0 }),
        )
    }
}
