@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A custom alert rule that checks if a value (depends on the custom alert type) is within the given range.
 * @property description The description of the custom alert.
 * @property displayName The display name of the custom alert.
 * @property isEnabled Status of the custom alert.
 * @property maxThreshold The maximum threshold.
 * @property minThreshold The minimum threshold.
 * @property ruleType The type of the custom alert rule.
 * Expected value is 'ThresholdCustomAlertRule'.
 */
public data class ThresholdCustomAlertRuleResponse(
    public val description: String,
    public val displayName: String,
    public val isEnabled: Boolean,
    public val maxThreshold: Int,
    public val minThreshold: Int,
    public val ruleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ThresholdCustomAlertRuleResponse): ThresholdCustomAlertRuleResponse = ThresholdCustomAlertRuleResponse(
            description = javaType.description(),
            displayName = javaType.displayName(),
            isEnabled = javaType.isEnabled(),
            maxThreshold = javaType.maxThreshold(),
            minThreshold = javaType.minThreshold(),
            ruleType = javaType.ruleType(),
        )
    }
}
