@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the IoT Security solution's user defined resources.
 * @property query Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
 * @property querySubscriptions List of Azure subscription ids on which the user defined resources query should be executed.
 */
public data class UserDefinedResourcesPropertiesResponse(
    public val query: String,
    public val querySubscriptions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.UserDefinedResourcesPropertiesResponse): UserDefinedResourcesPropertiesResponse = UserDefinedResourcesPropertiesResponse(
            query = javaType.query(),
            querySubscriptions = javaType.querySubscriptions().map({ args0 -> args0 }),
        )
    }
}
