@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a user that is recommended to be allowed for a certain rule
 * @property recommendationAction The recommendation action of the machine or rule
 * @property username Represents a user that is recommended to be allowed for a certain rule
 */
public data class UserRecommendationResponse(
    public val recommendationAction: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.UserRecommendationResponse): UserRecommendationResponse = UserRecommendationResponse(
            recommendationAction = javaType.recommendationAction().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
