@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a machine that is part of a machine group
 * @property configurationStatus The configuration status of the machines group or machine or rule
 * @property enforcementSupport The machine supportability of Enforce feature
 * @property recommendationAction The recommendation action of the machine or rule
 * @property resourceId The full resource id of the machine
 */
public data class VmRecommendationResponse(
    public val configurationStatus: String? = null,
    public val enforcementSupport: String? = null,
    public val recommendationAction: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.VmRecommendationResponse): VmRecommendationResponse = VmRecommendationResponse(
            configurationStatus = javaType.configurationStatus().map({ args0 -> args0 }).orElse(null),
            enforcementSupport = javaType.enforcementSupport().map({ args0 -> args0 }).orElse(null),
            recommendationAction = javaType.recommendationAction().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
