@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.ServiceAuthenticationConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authentication configuration information
 * @property audience The audience url for the service
 * @property authority The authority url for the service
 * @property smartProxyEnabled If the SMART on FHIR proxy is enabled
 */
public data class ServiceAuthenticationConfigurationInfoArgs(
    public val audience: Output<String>? = null,
    public val authority: Output<String>? = null,
    public val smartProxyEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.ServiceAuthenticationConfigurationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityandcompliance.inputs.ServiceAuthenticationConfigurationInfoArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.ServiceAuthenticationConfigurationInfoArgs.builder()
            .audience(audience?.applyValue({ args0 -> args0 }))
            .authority(authority?.applyValue({ args0 -> args0 }))
            .smartProxyEnabled(smartProxyEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceAuthenticationConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceAuthenticationConfigurationInfoArgsBuilder internal constructor() {
    private var audience: Output<String>? = null

    private var authority: Output<String>? = null

    private var smartProxyEnabled: Output<Boolean>? = null

    /**
     * @param value The audience url for the service
     */
    @JvmName("qfookmdihmensrqn")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value The authority url for the service
     */
    @JvmName("jaxikifkvwhnqqqe")
    public suspend fun authority(`value`: Output<String>) {
        this.authority = value
    }

    /**
     * @param value If the SMART on FHIR proxy is enabled
     */
    @JvmName("gwkboxekwxykwefj")
    public suspend fun smartProxyEnabled(`value`: Output<Boolean>) {
        this.smartProxyEnabled = value
    }

    /**
     * @param value The audience url for the service
     */
    @JvmName("elligiromlywulqy")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value The authority url for the service
     */
    @JvmName("icshrlmiigkiatky")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authority = mapped
    }

    /**
     * @param value If the SMART on FHIR proxy is enabled
     */
    @JvmName("fikpyjyhaibwsoeg")
    public suspend fun smartProxyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smartProxyEnabled = mapped
    }

    internal fun build(): ServiceAuthenticationConfigurationInfoArgs =
        ServiceAuthenticationConfigurationInfoArgs(
            audience = audience,
            authority = authority,
            smartProxyEnabled = smartProxyEnabled,
        )
}
