@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The description of the service.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property id The resource identifier.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property kind The kind of the service.
 * @property location The resource location.
 * @property name The resource name.
 * @property properties The common properties of a service.
 * @property systemData Required property for system data
 * @property tags The resource tags.
 * @property type The resource type.
 */
public data class GetPrivateLinkServicesForM365SecurityCenterResult(
    public val etag: String? = null,
    public val id: String,
    public val identity: ServicesResourceResponseIdentity? = null,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val properties: ServicesPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityandcompliance.outputs.GetPrivateLinkServicesForM365SecurityCenterResult): GetPrivateLinkServicesForM365SecurityCenterResult =
            GetPrivateLinkServicesForM365SecurityCenterResult(
                etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.securityandcompliance.kotlin.outputs.ServicesResourceResponseIdentity.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                kind = javaType.kind(),
                location = javaType.location(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.securityandcompliance.kotlin.outputs.ServicesPropertiesResponse.Companion.toKotlin(args0)
                }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.securityandcompliance.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
