@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The settings for the Cosmos DB database backing the service.
 * @property keyVaultKeyUri The URI of the customer-managed key for the backing database.
 * @property offerThroughput The provisioned throughput for the backing database.
 */
public data class ServiceCosmosDbConfigurationInfoResponse(
    public val keyVaultKeyUri: String? = null,
    public val offerThroughput: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityandcompliance.outputs.ServiceCosmosDbConfigurationInfoResponse): ServiceCosmosDbConfigurationInfoResponse = ServiceCosmosDbConfigurationInfoResponse(
            keyVaultKeyUri = javaType.keyVaultKeyUri().map({ args0 -> args0 }).orElse(null),
            offerThroughput = javaType.offerThroughput().map({ args0 -> args0 }).orElse(null),
        )
    }
}
