@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin

import com.pulumi.azurenative.securitydevops.AzureDevOpsConnectorArgs.builder
import com.pulumi.azurenative.securitydevops.kotlin.inputs.AzureDevOpsConnectorPropertiesArgs
import com.pulumi.azurenative.securitydevops.kotlin.inputs.AzureDevOpsConnectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### AzureDevOpsConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureDevOpsConnector = new AzureNative.SecurityDevOps.AzureDevOpsConnector("azureDevOpsConnector", new()
 *     {
 *         AzureDevOpsConnectorName = "testconnector",
 *         Location = "West US",
 *         Properties = new AzureNative.SecurityDevOps.Inputs.AzureDevOpsConnectorPropertiesArgs
 *         {
 *             Authorization = new AzureNative.SecurityDevOps.Inputs.AuthorizationInfoArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             Orgs = new[]
 *             {
 *                 new AzureNative.SecurityDevOps.Inputs.AzureDevOpsOrgMetadataArgs
 *                 {
 *                     Name = "testOrg",
 *                     Projects = new[]
 *                     {
 *                         new AzureNative.SecurityDevOps.Inputs.AzureDevOpsProjectMetadataArgs
 *                         {
 *                             Name = "testProject",
 *                             Repos = new[]
 *                             {
 *                                 "testRepo",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "westusrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securitydevops/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitydevops.NewAzureDevOpsConnector(ctx, "azureDevOpsConnector", &securitydevops.AzureDevOpsConnectorArgs{
 * 			AzureDevOpsConnectorName: pulumi.String("testconnector"),
 * 			Location:                 pulumi.String("West US"),
 * 			Properties: &securitydevops.AzureDevOpsConnectorPropertiesArgs{
 * 				Authorization: &securitydevops.AuthorizationInfoArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				Orgs: securitydevops.AzureDevOpsOrgMetadataArray{
 * 					&securitydevops.AzureDevOpsOrgMetadataArgs{
 * 						Name: pulumi.String("testOrg"),
 * 						Projects: securitydevops.AzureDevOpsProjectMetadataArray{
 * 							&securitydevops.AzureDevOpsProjectMetadataArgs{
 * 								Name: pulumi.String("testProject"),
 * 								Repos: pulumi.StringArray{
 * 									pulumi.String("testRepo"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("westusrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securitydevops.AzureDevOpsConnector;
 * import com.pulumi.azurenative.securitydevops.AzureDevOpsConnectorArgs;
 * import com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsConnectorPropertiesArgs;
 * import com.pulumi.azurenative.securitydevops.inputs.AuthorizationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureDevOpsConnector = new AzureDevOpsConnector("azureDevOpsConnector", AzureDevOpsConnectorArgs.builder()
 *             .azureDevOpsConnectorName("testconnector")
 *             .location("West US")
 *             .properties(AzureDevOpsConnectorPropertiesArgs.builder()
 *                 .authorization(AuthorizationInfoArgs.builder()
 *                     .code("00000000000000000000")
 *                     .build())
 *                 .orgs(AzureDevOpsOrgMetadataArgs.builder()
 *                     .name("testOrg")
 *                     .projects(AzureDevOpsProjectMetadataArgs.builder()
 *                         .name("testProject")
 *                         .repos("testRepo")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("westusrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securitydevops:AzureDevOpsConnector testconnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}
 * ```
 * @property azureDevOpsConnectorName Name of the AzureDevOps Connector.
 * @property location The geo-location where the resource lives
 * @property properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AzureDevOpsConnectorArgs(
    public val azureDevOpsConnectorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AzureDevOpsConnectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.AzureDevOpsConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.AzureDevOpsConnectorArgs =
        com.pulumi.azurenative.securitydevops.AzureDevOpsConnectorArgs.builder()
            .azureDevOpsConnectorName(azureDevOpsConnectorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureDevOpsConnectorArgs].
 */
@PulumiTagMarker
public class AzureDevOpsConnectorArgsBuilder internal constructor() {
    private var azureDevOpsConnectorName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<AzureDevOpsConnectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the AzureDevOps Connector.
     */
    @JvmName("bcesoqjvjvtjgbiu")
    public suspend fun azureDevOpsConnectorName(`value`: Output<String>) {
        this.azureDevOpsConnectorName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gtwjmlpesqdoetfp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("xnjjhmujaabcelor")
    public suspend fun properties(`value`: Output<AzureDevOpsConnectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tvhpnvcybdamqkjp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fykukojgeyfbyvae")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the AzureDevOps Connector.
     */
    @JvmName("udoxoreeqxacljaq")
    public suspend fun azureDevOpsConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDevOpsConnectorName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vmqpqcfrjmabqlcg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("mjfhufvahpmdmkkd")
    public suspend fun properties(`value`: AzureDevOpsConnectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rkwaxcimsvgvexrs")
    public suspend fun properties(argument: suspend AzureDevOpsConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDevOpsConnectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qbdwpmrktpaedlqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eqawopiqnqlskktp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ihifyaehdckblqif")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureDevOpsConnectorArgs = AzureDevOpsConnectorArgs(
        azureDevOpsConnectorName = azureDevOpsConnectorName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
