@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin

import com.pulumi.azurenative.securitydevops.GitHubConnectorArgs.builder
import com.pulumi.azurenative.securitydevops.kotlin.inputs.GitHubConnectorPropertiesArgs
import com.pulumi.azurenative.securitydevops.kotlin.inputs.GitHubConnectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### GitHubConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gitHubConnector = new AzureNative.SecurityDevOps.GitHubConnector("gitHubConnector", new()
 *     {
 *         GitHubConnectorName = "testconnector",
 *         Location = "West US",
 *         Properties = new AzureNative.SecurityDevOps.Inputs.GitHubConnectorPropertiesArgs
 *         {
 *             Code = "00000000000000000000",
 *         },
 *         ResourceGroupName = "westusrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securitydevops/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitydevops.NewGitHubConnector(ctx, "gitHubConnector", &securitydevops.GitHubConnectorArgs{
 * 			GitHubConnectorName: pulumi.String("testconnector"),
 * 			Location:            pulumi.String("West US"),
 * 			Properties: &securitydevops.GitHubConnectorPropertiesArgs{
 * 				Code: pulumi.String("00000000000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("westusrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securitydevops.GitHubConnector;
 * import com.pulumi.azurenative.securitydevops.GitHubConnectorArgs;
 * import com.pulumi.azurenative.securitydevops.inputs.GitHubConnectorPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gitHubConnector = new GitHubConnector("gitHubConnector", GitHubConnectorArgs.builder()
 *             .gitHubConnectorName("testconnector")
 *             .location("West US")
 *             .properties(GitHubConnectorPropertiesArgs.builder()
 *                 .code("00000000000000000000")
 *                 .build())
 *             .resourceGroupName("westusrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securitydevops:GitHubConnector testconnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}
 * ```
 * @property gitHubConnectorName Name of the GitHub Connector.
 * @property location The geo-location where the resource lives
 * @property properties Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class GitHubConnectorArgs(
    public val gitHubConnectorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<GitHubConnectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.GitHubConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.GitHubConnectorArgs =
        com.pulumi.azurenative.securitydevops.GitHubConnectorArgs.builder()
            .gitHubConnectorName(gitHubConnectorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GitHubConnectorArgs].
 */
@PulumiTagMarker
public class GitHubConnectorArgsBuilder internal constructor() {
    private var gitHubConnectorName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<GitHubConnectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the GitHub Connector.
     */
    @JvmName("ebjtfjhluqojtxfy")
    public suspend fun gitHubConnectorName(`value`: Output<String>) {
        this.gitHubConnectorName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ypegsmbauepknhgr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    @JvmName("qjbnpajefmvwexqg")
    public suspend fun properties(`value`: Output<GitHubConnectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oursywidgblwgxhx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rcbopkvphxpgjrel")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the GitHub Connector.
     */
    @JvmName("yomumsuovedliulw")
    public suspend fun gitHubConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubConnectorName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ljhjrsdgdadkbqib")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    @JvmName("ewxphhgnwfrrtmbf")
    public suspend fun properties(`value`: GitHubConnectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    @JvmName("erlycpfdbghayjqo")
    public suspend fun properties(argument: suspend GitHubConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubConnectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvroibtopnyuhcxy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xyskiqfxdawasssl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("trfkaedvmbjrheqs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GitHubConnectorArgs = GitHubConnectorArgs(
        gitHubConnectorName = gitHubConnectorName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
