@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin

import com.pulumi.azurenative.securitydevops.SecuritydevopsFunctions.getAzureDevOpsConnectorPlain
import com.pulumi.azurenative.securitydevops.SecuritydevopsFunctions.getGitHubConnectorPlain
import com.pulumi.azurenative.securitydevops.kotlin.inputs.GetAzureDevOpsConnectorPlainArgs
import com.pulumi.azurenative.securitydevops.kotlin.inputs.GetAzureDevOpsConnectorPlainArgsBuilder
import com.pulumi.azurenative.securitydevops.kotlin.inputs.GetGitHubConnectorPlainArgs
import com.pulumi.azurenative.securitydevops.kotlin.inputs.GetGitHubConnectorPlainArgsBuilder
import com.pulumi.azurenative.securitydevops.kotlin.outputs.GetAzureDevOpsConnectorResult
import com.pulumi.azurenative.securitydevops.kotlin.outputs.GetGitHubConnectorResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securitydevops.kotlin.outputs.GetAzureDevOpsConnectorResult.Companion.toKotlin as getAzureDevOpsConnectorResultToKotlin
import com.pulumi.azurenative.securitydevops.kotlin.outputs.GetGitHubConnectorResult.Companion.toKotlin as getGitHubConnectorResultToKotlin

public object SecuritydevopsFunctions {
    /**
     *
     * Azure REST API version: 2022-09-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getAzureDevOpsConnector(argument: GetAzureDevOpsConnectorPlainArgs): GetAzureDevOpsConnectorResult =
        getAzureDevOpsConnectorResultToKotlin(getAzureDevOpsConnectorPlain(argument.toJava()).await())

    /**
     * @see [getAzureDevOpsConnector].
     * @param azureDevOpsConnectorName Name of the AzureDevOps Connector.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getAzureDevOpsConnector(
        azureDevOpsConnectorName: String,
        resourceGroupName: String,
    ): GetAzureDevOpsConnectorResult {
        val argument = GetAzureDevOpsConnectorPlainArgs(
            azureDevOpsConnectorName = azureDevOpsConnectorName,
            resourceGroupName = resourceGroupName,
        )
        return getAzureDevOpsConnectorResultToKotlin(getAzureDevOpsConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureDevOpsConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securitydevops&#46;kotlin&#46;inputs&#46;GetAzureDevOpsConnectorPlainArgs].
     * @return null
     */
    public suspend fun getAzureDevOpsConnector(argument: suspend GetAzureDevOpsConnectorPlainArgsBuilder.() -> Unit): GetAzureDevOpsConnectorResult {
        val builder = GetAzureDevOpsConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureDevOpsConnectorResultToKotlin(getAzureDevOpsConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     * Azure REST API version: 2022-09-01-preview.
     * @param argument null
     * @return Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    public suspend fun getGitHubConnector(argument: GetGitHubConnectorPlainArgs): GetGitHubConnectorResult =
        getGitHubConnectorResultToKotlin(getGitHubConnectorPlain(argument.toJava()).await())

    /**
     * @see [getGitHubConnector].
     * @param gitHubConnectorName Name of the GitHub Connector.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    public suspend fun getGitHubConnector(gitHubConnectorName: String, resourceGroupName: String): GetGitHubConnectorResult {
        val argument = GetGitHubConnectorPlainArgs(
            gitHubConnectorName = gitHubConnectorName,
            resourceGroupName = resourceGroupName,
        )
        return getGitHubConnectorResultToKotlin(getGitHubConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getGitHubConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securitydevops&#46;kotlin&#46;inputs&#46;GetGitHubConnectorPlainArgs].
     * @return Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
     */
    public suspend fun getGitHubConnector(argument: suspend GetGitHubConnectorPlainArgsBuilder.() -> Unit): GetGitHubConnectorResult {
        val builder = GetGitHubConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGitHubConnectorResultToKotlin(getGitHubConnectorPlain(builtArgument.toJava()).await())
    }
}
