@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.AuthorizationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property code Gets or sets one-time OAuth code to exchange for refresh and access tokens.
 * Only used during PUT operations. The secret is cleared during GET.
 * In general, RPaaS does not return any property marked as a secret.
 */
public data class AuthorizationInfoArgs(
    public val code: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.AuthorizationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.inputs.AuthorizationInfoArgs =
        com.pulumi.azurenative.securitydevops.inputs.AuthorizationInfoArgs.builder()
            .code(code?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationInfoArgs].
 */
@PulumiTagMarker
public class AuthorizationInfoArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    /**
     * @param value Gets or sets one-time OAuth code to exchange for refresh and access tokens.
     * Only used during PUT operations. The secret is cleared during GET.
     * In general, RPaaS does not return any property marked as a secret.
     */
    @JvmName("nkrumyolofhvenqv")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Gets or sets one-time OAuth code to exchange for refresh and access tokens.
     * Only used during PUT operations. The secret is cleared during GET.
     * In general, RPaaS does not return any property marked as a secret.
     */
    @JvmName("svusqkoewqtgiqnh")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    internal fun build(): AuthorizationInfoArgs = AuthorizationInfoArgs(
        code = code,
    )
}
