@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsOrgMetadataArgs.builder
import com.pulumi.azurenative.securitydevops.kotlin.enums.AutoDiscovery
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Org onboarding info.
 * @property autoDiscovery
 * @property name Gets or sets name of the AzureDevOps Org.
 * @property projects
 */
public data class AzureDevOpsOrgMetadataArgs(
    public val autoDiscovery: Output<Either<String, AutoDiscovery>>? = null,
    public val name: Output<String>? = null,
    public val projects: Output<List<AzureDevOpsProjectMetadataArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsOrgMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsOrgMetadataArgs =
        com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsOrgMetadataArgs.builder()
            .autoDiscovery(
                autoDiscovery?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .projects(
                projects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureDevOpsOrgMetadataArgs].
 */
@PulumiTagMarker
public class AzureDevOpsOrgMetadataArgsBuilder internal constructor() {
    private var autoDiscovery: Output<Either<String, AutoDiscovery>>? = null

    private var name: Output<String>? = null

    private var projects: Output<List<AzureDevOpsProjectMetadataArgs>>? = null

    /**
     * @param value
     */
    @JvmName("eoessxuuuguacdnx")
    public suspend fun autoDiscovery(`value`: Output<Either<String, AutoDiscovery>>) {
        this.autoDiscovery = value
    }

    /**
     * @param value Gets or sets name of the AzureDevOps Org.
     */
    @JvmName("gdrvokafqnrknwsm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("enxggjgfglrifqwk")
    public suspend fun projects(`value`: Output<List<AzureDevOpsProjectMetadataArgs>>) {
        this.projects = value
    }

    @JvmName("lvuesemwygxdccqb")
    public suspend fun projects(vararg values: Output<AzureDevOpsProjectMetadataArgs>) {
        this.projects = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vuqyvassgbjrhobi")
    public suspend fun projects(values: List<Output<AzureDevOpsProjectMetadataArgs>>) {
        this.projects = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kweruauepaqpuaui")
    public suspend fun autoDiscovery(`value`: Either<String, AutoDiscovery>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value
     */
    @JvmName("fuvrwlsjvhaxyijo")
    public fun autoDiscovery(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoDiscovery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value
     */
    @JvmName("pyjqiobwuxxraikh")
    public fun autoDiscovery(`value`: AutoDiscovery) {
        val toBeMapped = Either.ofRight<String, AutoDiscovery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value Gets or sets name of the AzureDevOps Org.
     */
    @JvmName("dlskydcvwqwjsblf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("mwcfexruarljdpxq")
    public suspend fun projects(`value`: List<AzureDevOpsProjectMetadataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projects = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dlfynjumeuxapprx")
    public suspend fun projects(argument: List<suspend AzureDevOpsProjectMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureDevOpsProjectMetadataArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.projects = mapped
    }

    /**
     * @param argument
     */
    @JvmName("clyiwvxwxeyunamk")
    public suspend fun projects(vararg argument: suspend AzureDevOpsProjectMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureDevOpsProjectMetadataArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.projects = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iqygfrtiskxcedos")
    public suspend fun projects(argument: suspend AzureDevOpsProjectMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureDevOpsProjectMetadataArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.projects = mapped
    }

    /**
     * @param values
     */
    @JvmName("dtydmjdhmdwxoolc")
    public suspend fun projects(vararg values: AzureDevOpsProjectMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projects = mapped
    }

    internal fun build(): AzureDevOpsOrgMetadataArgs = AzureDevOpsOrgMetadataArgs(
        autoDiscovery = autoDiscovery,
        name = name,
        projects = projects,
    )
}
