@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authorization
 * @property orgs Gets or sets org onboarding information.
 * @property provisioningState
 */
public data class AzureDevOpsConnectorPropertiesResponse(
    public val authorization: AuthorizationInfoResponse? = null,
    public val orgs: List<AzureDevOpsOrgMetadataResponse>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securitydevops.outputs.AzureDevOpsConnectorPropertiesResponse): AzureDevOpsConnectorPropertiesResponse = AzureDevOpsConnectorPropertiesResponse(
            authorization = javaType.authorization().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securitydevops.kotlin.outputs.AuthorizationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            orgs = javaType.orgs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securitydevops.kotlin.outputs.AzureDevOpsOrgMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
