@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ActivityCustomEntityQueryArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.EntityType
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents Activity entity query.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### Creates or updates an Activity entity query.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityCustomEntityQuery = new AzureNative.SecurityInsights.ActivityCustomEntityQuery("activityCustomEntityQuery", new()
 *     {
 *         Content = "On '{{Computer}}' the account '{{TargetAccount}}' was deleted by '{{AddedBy}}'",
 *         Description = "Account deleted on host",
 *         Enabled = true,
 *         EntitiesFilter =
 *         {
 *             { "Host_OsFamily", new[]
 *             {
 *                 "Windows",
 *             } },
 *         },
 *         EntityQueryId = "07da3cc8-c8ad-4710-a44e-334cdcb7882b",
 *         InputEntityType = AzureNative.SecurityInsights.EntityType.Host,
 *         Kind = "Activity",
 *         QueryDefinitions = new AzureNative.SecurityInsights.Inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs
 *         {
 *             Query = @"let GetAccountActions = (v_Host_Name:string, v_Host_NTDomain:string, v_Host_DnsDomain:string, v_Host_AzureID:string, v_Host_OMSAgentID:string){
 * SecurityEvent
 * | where EventID in (4725, 4726, 4767, 4720, 4722, 4723, 4724)
 * // parsing for Host to handle variety of conventions coming from data
 * | extend Host_HostName = case(
 * Computer has '@', tostring(split(Computer, '@')[0]),
 * Computer has '\\', tostring(split(Computer, '\\')[1]),
 * Computer has '.', tostring(split(Computer, '.')[0]),
 * Computer
 * )
 * | extend Host_NTDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', tostring(split(Computer, '.')[-2]),
 * Computer
 * )
 * | extend Host_DnsDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', strcat_array(array_slice(split(Computer,'.'),-2,-1),'.'),
 * Computer
 * )
 * | where (Host_HostName =~ v_Host_Name and Host_NTDomain =~ v_Host_NTDomain)
 * or (Host_HostName =~ v_Host_Name and Host_DnsDomain =~ v_Host_DnsDomain)
 * or v_Host_AzureID =~ _ResourceId
 * or v_Host_OMSAgentID == SourceComputerId
 * | project TimeGenerated, EventID, Activity, Computer, TargetAccount, TargetUserName, TargetDomainName, TargetSid, SubjectUserName, SubjectUserSid, _ResourceId, SourceComputerId
 * | extend AddedBy = SubjectUserName
 * // Future support for Activities
 * | extend timestamp = TimeGenerated, HostCustomEntity = Computer, AccountCustomEntity = TargetAccount
 * };
 * GetAccountActions('{{Host_HostName}}', '{{Host_NTDomain}}', '{{Host_DnsDomain}}', '{{Host_AzureID}}', '{{Host_OMSAgentID}}')
 * | where EventID == 4726 ",
 *         },
 *         RequiredInputFieldsSets = new[]
 *         {
 *             new[]
 *             {
 *                 "Host_HostName",
 *                 "Host_NTDomain",
 *             },
 *             new[]
 *             {
 *                 "Host_HostName",
 *                 "Host_DnsDomain",
 *             },
 *             new[]
 *             {
 *                 "Host_AzureID",
 *             },
 *             new[]
 *             {
 *                 "Host_OMSAgentID",
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         Title = "An account was deleted on this host",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewActivityCustomEntityQuery(ctx, "activityCustomEntityQuery", &securityinsights.ActivityCustomEntityQueryArgs{
 * 			Content:     pulumi.String("On '{{Computer}}' the account '{{TargetAccount}}' was deleted by '{{AddedBy}}'"),
 * 			Description: pulumi.String("Account deleted on host"),
 * 			Enabled:     pulumi.Bool(true),
 * 			EntitiesFilter: pulumi.StringArrayMap{
 * 				"Host_OsFamily": pulumi.StringArray{
 * 					pulumi.String("Windows"),
 * 				},
 * 			},
 * 			EntityQueryId:   pulumi.String("07da3cc8-c8ad-4710-a44e-334cdcb7882b"),
 * 			InputEntityType: pulumi.String(securityinsights.EntityTypeHost),
 * 			Kind:            pulumi.String("Activity"),
 * 			QueryDefinitions: &securityinsights.ActivityEntityQueriesPropertiesQueryDefinitionsArgs{
 * 				Query: pulumi.String(`let GetAccountActions = (v_Host_Name:string, v_Host_NTDomain:string, v_Host_DnsDomain:string, v_Host_AzureID:string, v_Host_OMSAgentID:string){
 * SecurityEvent
 * | where EventID in (4725, 4726, 4767, 4720, 4722, 4723, 4724)
 * // parsing for Host to handle variety of conventions coming from data
 * | extend Host_HostName = case(
 * Computer has '@', tostring(split(Computer, '@')[0]),
 * Computer has '\\', tostring(split(Computer, '\\')[1]),
 * Computer has '.', tostring(split(Computer, '.')[0]),
 * Computer
 * )
 * | extend Host_NTDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', tostring(split(Computer, '.')[-2]),
 * Computer
 * )
 * | extend Host_DnsDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', strcat_array(array_slice(split(Computer,'.'),-2,-1),'.'),
 * Computer
 * )
 * | where (Host_HostName =~ v_Host_Name and Host_NTDomain =~ v_Host_NTDomain)
 * or (Host_HostName =~ v_Host_Name and Host_DnsDomain =~ v_Host_DnsDomain)
 * or v_Host_AzureID =~ _ResourceId
 * or v_Host_OMSAgentID == SourceComputerId
 * | project TimeGenerated, EventID, Activity, Computer, TargetAccount, TargetUserName, TargetDomainName, TargetSid, SubjectUserName, SubjectUserSid, _ResourceId, SourceComputerId
 * | extend AddedBy = SubjectUserName
 * // Future support for Activities
 * | extend timestamp = TimeGenerated, HostCustomEntity = Computer, AccountCustomEntity = TargetAccount
 * };
 * GetAccountActions('{{Host_HostName}}', '{{Host_NTDomain}}', '{{Host_DnsDomain}}', '{{Host_AzureID}}', '{{Host_OMSAgentID}}')
 * | where EventID == 4726 `),
 * 			},
 * 			RequiredInputFieldsSets: pulumi.StringArrayArray{
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_HostName"),
 * 					pulumi.String("Host_NTDomain"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_HostName"),
 * 					pulumi.String("Host_DnsDomain"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_AzureID"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_OMSAgentID"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Title:             pulumi.String("An account was deleted on this host"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ActivityCustomEntityQuery;
 * import com.pulumi.azurenative.securityinsights.ActivityCustomEntityQueryArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityCustomEntityQuery = new ActivityCustomEntityQuery("activityCustomEntityQuery", ActivityCustomEntityQueryArgs.builder()
 *             .content("On '{{Computer}}' the account '{{TargetAccount}}' was deleted by '{{AddedBy}}'")
 *             .description("Account deleted on host")
 *             .enabled(true)
 *             .entitiesFilter(Map.of("Host_OsFamily", "Windows"))
 *             .entityQueryId("07da3cc8-c8ad-4710-a44e-334cdcb7882b")
 *             .inputEntityType("Host")
 *             .kind("Activity")
 *             .queryDefinitions(ActivityEntityQueriesPropertiesQueryDefinitionsArgs.builder()
 *                 .query("""
 * let GetAccountActions = (v_Host_Name:string, v_Host_NTDomain:string, v_Host_DnsDomain:string, v_Host_AzureID:string, v_Host_OMSAgentID:string){
 * SecurityEvent
 * | where EventID in (4725, 4726, 4767, 4720, 4722, 4723, 4724)
 * // parsing for Host to handle variety of conventions coming from data
 * | extend Host_HostName = case(
 * Computer has '@', tostring(split(Computer, '@')[0]),
 * Computer has '\\', tostring(split(Computer, '\\')[1]),
 * Computer has '.', tostring(split(Computer, '.')[0]),
 * Computer
 * )
 * | extend Host_NTDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', tostring(split(Computer, '.')[-2]),
 * Computer
 * )
 * | extend Host_DnsDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', strcat_array(array_slice(split(Computer,'.'),-2,-1),'.'),
 * Computer
 * )
 * | where (Host_HostName =~ v_Host_Name and Host_NTDomain =~ v_Host_NTDomain)
 * or (Host_HostName =~ v_Host_Name and Host_DnsDomain =~ v_Host_DnsDomain)
 * or v_Host_AzureID =~ _ResourceId
 * or v_Host_OMSAgentID == SourceComputerId
 * | project TimeGenerated, EventID, Activity, Computer, TargetAccount, TargetUserName, TargetDomainName, TargetSid, SubjectUserName, SubjectUserSid, _ResourceId, SourceComputerId
 * | extend AddedBy = SubjectUserName
 * // Future support for Activities
 * | extend timestamp = TimeGenerated, HostCustomEntity = Computer, AccountCustomEntity = TargetAccount
 * };
 * GetAccountActions('{{Host_HostName}}', '{{Host_NTDomain}}', '{{Host_DnsDomain}}', '{{Host_AzureID}}', '{{Host_OMSAgentID}}')
 * | where EventID == 4726                 """)
 *                 .build())
 *             .requiredInputFieldsSets(
 *                     "Host_HostName",
 *                     "Host_NTDomain",
 *                     "Host_HostName",
 *                     "Host_DnsDomain",
 *                 "Host_AzureID",
 *                 "Host_OMSAgentID")
 *             .resourceGroupName("myRg")
 *             .title("An account was deleted on this host")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ActivityCustomEntityQuery 07da3cc8-c8ad-4710-a44e-334cdcb7882b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}
 * ```
 * @property content The entity query content to display in timeline
 * @property description The entity query description
 * @property enabled Determines whether this activity is enabled or disabled.
 * @property entitiesFilter The query applied only to entities matching to all filters
 * @property entityQueryId entity query ID
 * @property inputEntityType The type of the query's source entity
 * @property kind The kind of the entity query that supports put request.
 * Expected value is 'Activity'.
 * @property queryDefinitions The Activity query definitions
 * @property requiredInputFieldsSets List of the fields of the source entity that are required to run the query
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property templateName The template id this activity was created from
 * @property title The entity query title
 * @property workspaceName The name of the workspace.
 */
public data class ActivityCustomEntityQueryArgs(
    public val content: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val entitiesFilter: Output<Map<String, List<String>>>? = null,
    public val entityQueryId: Output<String>? = null,
    public val inputEntityType: Output<Either<String, EntityType>>? = null,
    public val kind: Output<String>? = null,
    public val queryDefinitions: Output<ActivityEntityQueriesPropertiesQueryDefinitionsArgs>? = null,
    public val requiredInputFieldsSets: Output<List<List<String>>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val templateName: Output<String>? = null,
    public val title: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ActivityCustomEntityQueryArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ActivityCustomEntityQueryArgs =
        com.pulumi.azurenative.securityinsights.ActivityCustomEntityQueryArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .entitiesFilter(
                entitiesFilter?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0 }))
                    }).toMap()
                }),
            )
            .entityQueryId(entityQueryId?.applyValue({ args0 -> args0 }))
            .inputEntityType(
                inputEntityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .queryDefinitions(queryDefinitions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requiredInputFieldsSets(
                requiredInputFieldsSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.map({ args0 -> args0 })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActivityCustomEntityQueryArgs].
 */
@PulumiTagMarker
public class ActivityCustomEntityQueryArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var entitiesFilter: Output<Map<String, List<String>>>? = null

    private var entityQueryId: Output<String>? = null

    private var inputEntityType: Output<Either<String, EntityType>>? = null

    private var kind: Output<String>? = null

    private var queryDefinitions: Output<ActivityEntityQueriesPropertiesQueryDefinitionsArgs>? = null

    private var requiredInputFieldsSets: Output<List<List<String>>>? = null

    private var resourceGroupName: Output<String>? = null

    private var templateName: Output<String>? = null

    private var title: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The entity query content to display in timeline
     */
    @JvmName("srhjrsxouwrgwnuv")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The entity query description
     */
    @JvmName("yvkfdiyofuaghnpv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Determines whether this activity is enabled or disabled.
     */
    @JvmName("ahowlkaeewwgfiwc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The query applied only to entities matching to all filters
     */
    @JvmName("xhkkamhjetvmoueu")
    public suspend fun entitiesFilter(`value`: Output<Map<String, List<String>>>) {
        this.entitiesFilter = value
    }

    /**
     * @param value entity query ID
     */
    @JvmName("opfuemynhrebdkur")
    public suspend fun entityQueryId(`value`: Output<String>) {
        this.entityQueryId = value
    }

    /**
     * @param value The type of the query's source entity
     */
    @JvmName("wngerxtfvjacswvr")
    public suspend fun inputEntityType(`value`: Output<Either<String, EntityType>>) {
        this.inputEntityType = value
    }

    /**
     * @param value The kind of the entity query that supports put request.
     * Expected value is 'Activity'.
     */
    @JvmName("oxfkanovonevanie")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The Activity query definitions
     */
    @JvmName("rrxcqaodyjfkjssl")
    public suspend fun queryDefinitions(`value`: Output<ActivityEntityQueriesPropertiesQueryDefinitionsArgs>) {
        this.queryDefinitions = value
    }

    /**
     * @param value List of the fields of the source entity that are required to run the query
     */
    @JvmName("wbsebxkttxxmsgtm")
    public suspend fun requiredInputFieldsSets(`value`: Output<List<List<String>>>) {
        this.requiredInputFieldsSets = value
    }

    @JvmName("nvhgidfwcrjvyhcy")
    public suspend fun requiredInputFieldsSets(vararg values: Output<List<String>>) {
        this.requiredInputFieldsSets = Output.all(values.asList())
    }

    /**
     * @param values List of the fields of the source entity that are required to run the query
     */
    @JvmName("atnjtljwlqdyrugv")
    public suspend fun requiredInputFieldsSets(values: List<Output<List<String>>>) {
        this.requiredInputFieldsSets = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqktpvtyrlagjkkl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The template id this activity was created from
     */
    @JvmName("xieikulwamjfwwae")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The entity query title
     */
    @JvmName("veiyanpbgomeoxja")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("blbnjmbonqtuktye")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The entity query content to display in timeline
     */
    @JvmName("wgaxyutltspurdpl")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The entity query description
     */
    @JvmName("yvlbhfyhfriygcuq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Determines whether this activity is enabled or disabled.
     */
    @JvmName("yphnjnsrluuhuqgb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The query applied only to entities matching to all filters
     */
    @JvmName("hdpynmdvnprrcpre")
    public suspend fun entitiesFilter(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entitiesFilter = mapped
    }

    /**
     * @param values The query applied only to entities matching to all filters
     */
    @JvmName("nefmpeiuytiqawaf")
    public fun entitiesFilter(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entitiesFilter = mapped
    }

    /**
     * @param value entity query ID
     */
    @JvmName("qtverqwelmhmmjao")
    public suspend fun entityQueryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityQueryId = mapped
    }

    /**
     * @param value The type of the query's source entity
     */
    @JvmName("yhjoxbnbhddpbyin")
    public suspend fun inputEntityType(`value`: Either<String, EntityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputEntityType = mapped
    }

    /**
     * @param value The type of the query's source entity
     */
    @JvmName("ivxqvxogkrejugmr")
    public fun inputEntityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EntityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputEntityType = mapped
    }

    /**
     * @param value The type of the query's source entity
     */
    @JvmName("oapvslqvlpclhkld")
    public fun inputEntityType(`value`: EntityType) {
        val toBeMapped = Either.ofRight<String, EntityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputEntityType = mapped
    }

    /**
     * @param value The kind of the entity query that supports put request.
     * Expected value is 'Activity'.
     */
    @JvmName("evqjxedefhhrqbhj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The Activity query definitions
     */
    @JvmName("cerbgpafeofehxpu")
    public suspend fun queryDefinitions(`value`: ActivityEntityQueriesPropertiesQueryDefinitionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryDefinitions = mapped
    }

    /**
     * @param argument The Activity query definitions
     */
    @JvmName("lvsrfhfanjwosthw")
    public suspend fun queryDefinitions(argument: suspend ActivityEntityQueriesPropertiesQueryDefinitionsArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityEntityQueriesPropertiesQueryDefinitionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.queryDefinitions = mapped
    }

    /**
     * @param value List of the fields of the source entity that are required to run the query
     */
    @JvmName("vhjgndgmadlsbocd")
    public suspend fun requiredInputFieldsSets(`value`: List<List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredInputFieldsSets = mapped
    }

    /**
     * @param values List of the fields of the source entity that are required to run the query
     */
    @JvmName("kfdbwuatiiivwvbc")
    public suspend fun requiredInputFieldsSets(vararg values: List<String>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredInputFieldsSets = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bsyepnoaftjvvskt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The template id this activity was created from
     */
    @JvmName("awcdyfiafqeqyxmi")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value The entity query title
     */
    @JvmName("pbplvlrblobwtibt")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("losocmopfttnfhog")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ActivityCustomEntityQueryArgs = ActivityCustomEntityQueryArgs(
        content = content,
        description = description,
        enabled = enabled,
        entitiesFilter = entitiesFilter,
        entityQueryId = entityQueryId,
        inputEntityType = inputEntityType,
        kind = kind,
        queryDefinitions = queryDefinitions,
        requiredInputFieldsSets = requiredInputFieldsSets,
        resourceGroupName = resourceGroupName,
        templateName = templateName,
        title = title,
        workspaceName = workspaceName,
    )
}
