@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.AwsCloudTrailDataConnectorDataTypesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityinsights.kotlin.outputs.AwsCloudTrailDataConnectorDataTypesResponse.Companion.toKotlin as awsCloudTrailDataConnectorDataTypesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AwsCloudTrailDataConnector].
 */
@PulumiTagMarker
public class AwsCloudTrailDataConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AwsCloudTrailDataConnectorArgs = AwsCloudTrailDataConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AwsCloudTrailDataConnectorArgsBuilder.() -> Unit) {
        val builder = AwsCloudTrailDataConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AwsCloudTrailDataConnector {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AwsCloudTrailDataConnector(builtJavaResource)
    }
}

/**
 * Represents Amazon Web Services CloudTrail data connector.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates an Office365 data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awsCloudTrailDataConnector = new AzureNative.SecurityInsights.AwsCloudTrailDataConnector("awsCloudTrailDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAwsCloudTrailDataConnector(ctx, "awsCloudTrailDataConnector", &securityinsights.AwsCloudTrailDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsCloudTrailDataConnector = new AwsCloudTrailDataConnector("awsCloudTrailDataConnector", AwsCloudTrailDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an Threat Intelligence Platform data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awsCloudTrailDataConnector = new AzureNative.SecurityInsights.AwsCloudTrailDataConnector("awsCloudTrailDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAwsCloudTrailDataConnector(ctx, "awsCloudTrailDataConnector", &securityinsights.AwsCloudTrailDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector;
 * import com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsCloudTrailDataConnector = new AwsCloudTrailDataConnector("awsCloudTrailDataConnector", AwsCloudTrailDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:AwsCloudTrailDataConnector 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectors/{dataConnectorId}
 * ```
 */
public class AwsCloudTrailDataConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector,
) : KotlinCustomResource(javaResource, AwsCloudTrailDataConnectorMapper) {
    /**
     * The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
     */
    public val awsRoleArn: Output<String>?
        get() = javaResource.awsRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The available data types for the connector.
     */
    public val dataTypes: Output<AwsCloudTrailDataConnectorDataTypesResponse>?
        get() = javaResource.dataTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    awsCloudTrailDataConnectorDataTypesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the data connector
     * Expected value is 'AmazonWebServicesCloudTrail'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AwsCloudTrailDataConnectorMapper : ResourceMapper<AwsCloudTrailDataConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector::class == javaResource::class

    override fun map(javaResource: Resource): AwsCloudTrailDataConnector =
        AwsCloudTrailDataConnector(
            javaResource as
                com.pulumi.azurenative.securityinsights.AwsCloudTrailDataConnector,
        )
}

/**
 * @see [AwsCloudTrailDataConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AwsCloudTrailDataConnector].
 */
public suspend fun awsCloudTrailDataConnector(
    name: String,
    block: suspend AwsCloudTrailDataConnectorResourceBuilder.() -> Unit,
): AwsCloudTrailDataConnector {
    val builder = AwsCloudTrailDataConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AwsCloudTrailDataConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun awsCloudTrailDataConnector(name: String): AwsCloudTrailDataConnector {
    val builder = AwsCloudTrailDataConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
