@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.BookmarkRelationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a relation between two resources
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2019-01-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a bookmark relation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bookmarkRelation = new AzureNative.SecurityInsights.BookmarkRelation("bookmarkRelation", new()
 *     {
 *         BookmarkId = "2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         RelatedResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/incidents/afbd324f-6c48-459c-8710-8d1e1cd03812",
 *         RelationName = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewBookmarkRelation(ctx, "bookmarkRelation", &securityinsights.BookmarkRelationArgs{
 * 			BookmarkId:        pulumi.String("2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			RelatedResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/incidents/afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 			RelationName:      pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.BookmarkRelation;
 * import com.pulumi.azurenative.securityinsights.BookmarkRelationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bookmarkRelation = new BookmarkRelation("bookmarkRelation", BookmarkRelationArgs.builder()
 *             .bookmarkId("2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .relatedResourceId("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/incidents/afbd324f-6c48-459c-8710-8d1e1cd03812")
 *             .relationName("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:BookmarkRelation 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/bookmarks/{bookmarkId}/relations/{relationName}
 * ```
 * @property bookmarkId Bookmark ID
 * @property relatedResourceId The resource ID of the related resource
 * @property relationName Relation Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class BookmarkRelationArgs(
    public val bookmarkId: Output<String>? = null,
    public val relatedResourceId: Output<String>? = null,
    public val relationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.BookmarkRelationArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.BookmarkRelationArgs =
        com.pulumi.azurenative.securityinsights.BookmarkRelationArgs.builder()
            .bookmarkId(bookmarkId?.applyValue({ args0 -> args0 }))
            .relatedResourceId(relatedResourceId?.applyValue({ args0 -> args0 }))
            .relationName(relationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BookmarkRelationArgs].
 */
@PulumiTagMarker
public class BookmarkRelationArgsBuilder internal constructor() {
    private var bookmarkId: Output<String>? = null

    private var relatedResourceId: Output<String>? = null

    private var relationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Bookmark ID
     */
    @JvmName("elaoqucescxxbwvp")
    public suspend fun bookmarkId(`value`: Output<String>) {
        this.bookmarkId = value
    }

    /**
     * @param value The resource ID of the related resource
     */
    @JvmName("phjeyudpjqlojato")
    public suspend fun relatedResourceId(`value`: Output<String>) {
        this.relatedResourceId = value
    }

    /**
     * @param value Relation Name
     */
    @JvmName("gsgbdrisogbvltnf")
    public suspend fun relationName(`value`: Output<String>) {
        this.relationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vnkphbqoyrrdnnnm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dqebvijpaqxuouqc")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Bookmark ID
     */
    @JvmName("bnmdtnpabfalwuxq")
    public suspend fun bookmarkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bookmarkId = mapped
    }

    /**
     * @param value The resource ID of the related resource
     */
    @JvmName("cpajaqambuicixmm")
    public suspend fun relatedResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedResourceId = mapped
    }

    /**
     * @param value Relation Name
     */
    @JvmName("clxcwlrnjyrdyxkh")
    public suspend fun relationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cbxwyiejcsdbfgmj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("vhqxkocudrvyenvq")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): BookmarkRelationArgs = BookmarkRelationArgs(
        bookmarkId = bookmarkId,
        relatedResourceId = relatedResourceId,
        relationName = relationName,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
