@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ContentTemplateArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.Kind
import com.pulumi.azurenative.securityinsights.kotlin.enums.PackageKind
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataAuthorArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataAuthorArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataCategoriesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataCategoriesArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataDependenciesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataDependenciesArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSourceArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSourceArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSupportArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.MetadataSupportArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Template resource definition.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### Get a template.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentTemplate = new AzureNative.SecurityInsights.ContentTemplate("contentTemplate", new()
 *     {
 *         Author = new AzureNative.SecurityInsights.Inputs.MetadataAuthorArgs
 *         {
 *             Email = "support@microsoft.com",
 *             Name = "Microsoft",
 *         },
 *         ContentId = "8365ebfe-a381-45b7-ad08-7d818070e11f",
 *         ContentKind = AzureNative.SecurityInsights.Kind.AnalyticsRule,
 *         DisplayName = "API Protection workbook template",
 *         MainTemplate = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
 *             ["contentVersion"] = "1.0.1",
 *             ["resources"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["apiVersion"] = "2022-04-01-preview",
 *                     ["kind"] = "Scheduled",
 *                     ["location"] = "[parameters('workspace-location')]",
 *                     ["name"] = "8365ebfe-a381-45b7-ad08-7d818070e11f",
 *                     ["properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["description"] = "Creates an incident when a large number of Critical/High severity CrowdStrike Falcon sensor detections is triggered by a single user",
 *                         ["displayName"] = "Critical or High Severity Detections by User",
 *                         ["enabled"] = false,
 *                         ["query"] = "...",
 *                         ["queryFrequency"] = "PT1H",
 *                         ["queryPeriod"] = "PT1H",
 *                         ["severity"] = "High",
 *                         ["status"] = "Available",
 *                         ["suppressionDuration"] = "PT1H",
 *                         ["suppressionEnabled"] = false,
 *                         ["triggerOperator"] = "GreaterThan",
 *                         ["triggerThreshold"] = 0,
 *                     },
 *                     ["type"] = "Microsoft.SecurityInsights/AlertRuleTemplates",
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["apiVersion"] = "2022-01-01-preview",
 *                     ["name"] = "[concat(parameters('workspace'),'/Microsoft.SecurityInsights/',concat('AnalyticsRule-', last(split([resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)],'/'))))]",
 *                     ["properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["author"] = new Dictionary<string, object?>
 *                         {
 *                             ["email"] = "support@microsoft.com",
 *                             ["name"] = "Microsoft",
 *                         },
 *                         ["contentId"] = "4465ebde-b381-45f7-ad08-7d818070a11c",
 *                         ["description"] = "CrowdStrike Falcon Endpoint Protection Analytics Rule 1",
 *                         ["kind"] = "AnalyticsRule",
 *                         ["parentId"] = "[resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)]",
 *                         ["source"] = new Dictionary<string, object?>
 *                         {
 *                             ["kind"] = "Solution",
 *                             ["name"] = "str",
 *                             ["sourceId"] = "str.azure-sentinel-solution-str",
 *                         },
 *                         ["support"] = new Dictionary<string, object?>
 *                         {
 *                             ["email"] = "support@microsoft.com",
 *                             ["link"] = "https://support.microsoft.com/",
 *                             ["name"] = "Microsoft Corporation",
 *                             ["tier"] = "Microsoft",
 *                         },
 *                         ["version"] = "1.0.0",
 *                     },
 *                     ["type"] = "Microsoft.OperationalInsights/workspaces/providers/metadata",
 *                 },
 *             },
 *         },
 *         PackageId = "str.azure-sentinel-solution-str",
 *         PackageKind = AzureNative.SecurityInsights.PackageKind.Solution,
 *         PackageName = "str",
 *         ResourceGroupName = "myRg",
 *         Source = new AzureNative.SecurityInsights.Inputs.MetadataSourceArgs
 *         {
 *             Kind = AzureNative.SecurityInsights.SourceKind.Solution,
 *             Name = "str",
 *             SourceId = "str.azure-sentinel-solution-str",
 *         },
 *         Support = new AzureNative.SecurityInsights.Inputs.MetadataSupportArgs
 *         {
 *             Email = "support@microsoft.com",
 *             Link = "https://support.microsoft.com/",
 *             Name = "Microsoft Corporation",
 *             Tier = AzureNative.SecurityInsights.SupportTier.Microsoft,
 *         },
 *         TemplateId = "str.azure-sentinel-solution-str",
 *         Version = "1.0.1",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewContentTemplate(ctx, "contentTemplate", &securityinsights.ContentTemplateArgs{
 * 			Author: &securityinsights.MetadataAuthorArgs{
 * 				Email: pulumi.String("support@microsoft.com"),
 * 				Name:  pulumi.String("Microsoft"),
 * 			},
 * 			ContentId:   pulumi.String("8365ebfe-a381-45b7-ad08-7d818070e11f"),
 * 			ContentKind: pulumi.String(securityinsights.KindAnalyticsRule),
 * 			DisplayName: pulumi.String("API Protection workbook template"),
 * 			MainTemplate: pulumi.Any(map[string]interface{}{
 * 				"$schema":        "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
 * 				"contentVersion": "1.0.1",
 * 				"resources": []interface{}{
 * 					map[string]interface{}{
 * 						"apiVersion": "2022-04-01-preview",
 * 						"kind":       "Scheduled",
 * 						"location":   "[parameters('workspace-location')]",
 * 						"name":       "8365ebfe-a381-45b7-ad08-7d818070e11f",
 * 						"properties": map[string]interface{}{
 * 							"description":         "Creates an incident when a large number of Critical/High severity CrowdStrike Falcon sensor detections is triggered by a single user",
 * 							"displayName":         "Critical or High Severity Detections by User",
 * 							"enabled":             false,
 * 							"query":               "...",
 * 							"queryFrequency":      "PT1H",
 * 							"queryPeriod":         "PT1H",
 * 							"severity":            "High",
 * 							"status":              "Available",
 * 							"suppressionDuration": "PT1H",
 * 							"suppressionEnabled":  false,
 * 							"triggerOperator":     "GreaterThan",
 * 							"triggerThreshold":    0,
 * 						},
 * 						"type": "Microsoft.SecurityInsights/AlertRuleTemplates",
 * 					},
 * 					map[string]interface{}{
 * 						"apiVersion": "2022-01-01-preview",
 * 						"name":       "[concat(parameters('workspace'),'/Microsoft.SecurityInsights/',concat('AnalyticsRule-', last(split([resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)],'/'))))]",
 * 						"properties": map[string]interface{}{
 * 							"author": map[string]interface{}{
 * 								"email": "support@microsoft.com",
 * 								"name":  "Microsoft",
 * 							},
 * 							"contentId":   "4465ebde-b381-45f7-ad08-7d818070a11c",
 * 							"description": "CrowdStrike Falcon Endpoint Protection Analytics Rule 1",
 * 							"kind":        "AnalyticsRule",
 * 							"parentId":    "[resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)]",
 * 							"source": map[string]interface{}{
 * 								"kind":     "Solution",
 * 								"name":     "str",
 * 								"sourceId": "str.azure-sentinel-solution-str",
 * 							},
 * 							"support": map[string]interface{}{
 * 								"email": "support@microsoft.com",
 * 								"link":  "https://support.microsoft.com/",
 * 								"name":  "Microsoft Corporation",
 * 								"tier":  "Microsoft",
 * 							},
 * 							"version": "1.0.0",
 * 						},
 * 						"type": "Microsoft.OperationalInsights/workspaces/providers/metadata",
 * 					},
 * 				},
 * 			}),
 * 			PackageId:         pulumi.String("str.azure-sentinel-solution-str"),
 * 			PackageKind:       pulumi.String(securityinsights.PackageKindSolution),
 * 			PackageName:       pulumi.String("str"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Source: &securityinsights.MetadataSourceArgs{
 * 				Kind:     pulumi.String(securityinsights.SourceKindSolution),
 * 				Name:     pulumi.String("str"),
 * 				SourceId: pulumi.String("str.azure-sentinel-solution-str"),
 * 			},
 * 			Support: &securityinsights.MetadataSupportArgs{
 * 				Email: pulumi.String("support@microsoft.com"),
 * 				Link:  pulumi.String("https://support.microsoft.com/"),
 * 				Name:  pulumi.String("Microsoft Corporation"),
 * 				Tier:  pulumi.String(securityinsights.SupportTierMicrosoft),
 * 			},
 * 			TemplateId:    pulumi.String("str.azure-sentinel-solution-str"),
 * 			Version:       pulumi.String("1.0.1"),
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ContentTemplate;
 * import com.pulumi.azurenative.securityinsights.ContentTemplateArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.MetadataAuthorArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.MetadataSourceArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.MetadataSupportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentTemplate = new ContentTemplate("contentTemplate", ContentTemplateArgs.builder()
 *             .author(MetadataAuthorArgs.builder()
 *                 .email("support@microsoft.com")
 *                 .name("Microsoft")
 *                 .build())
 *             .contentId("8365ebfe-a381-45b7-ad08-7d818070e11f")
 *             .contentKind("AnalyticsRule")
 *             .displayName("API Protection workbook template")
 *             .mainTemplate(Map.ofEntries(
 *                 Map.entry("$schema", "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#"),
 *                 Map.entry("contentVersion", "1.0.1"),
 *                 Map.entry("resources",
 *                     Map.ofEntries(
 *                         Map.entry("apiVersion", "2022-04-01-preview"),
 *                         Map.entry("kind", "Scheduled"),
 *                         Map.entry("location", "[parameters('workspace-location')]"),
 *                         Map.entry("name", "8365ebfe-a381-45b7-ad08-7d818070e11f"),
 *                         Map.entry("properties", Map.ofEntries(
 *                             Map.entry("description", "Creates an incident when a large number of Critical/High severity CrowdStrike Falcon sensor detections is triggered by a single user"),
 *                             Map.entry("displayName", "Critical or High Severity Detections by User"),
 *                             Map.entry("enabled", false),
 *                             Map.entry("query", "..."),
 *                             Map.entry("queryFrequency", "PT1H"),
 *                             Map.entry("queryPeriod", "PT1H"),
 *                             Map.entry("severity", "High"),
 *                             Map.entry("status", "Available"),
 *                             Map.entry("suppressionDuration", "PT1H"),
 *                             Map.entry("suppressionEnabled", false),
 *                             Map.entry("triggerOperator", "GreaterThan"),
 *                             Map.entry("triggerThreshold", 0)
 *                         )),
 *                         Map.entry("type", "Microsoft.SecurityInsights/AlertRuleTemplates")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("apiVersion", "2022-01-01-preview"),
 *                         Map.entry("name", "[concat(parameters('workspace'),'/Microsoft.SecurityInsights/',concat('AnalyticsRule-', last(split([resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)],'/'))))]"),
 *                         Map.entry("properties", Map.ofEntries(
 *                             Map.entry("author", Map.ofEntries(
 *                                 Map.entry("email", "support@microsoft.com"),
 *                                 Map.entry("name", "Microsoft")
 *                             )),
 *                             Map.entry("contentId", "4465ebde-b381-45f7-ad08-7d818070a11c"),
 *                             Map.entry("description", "CrowdStrike Falcon Endpoint Protection Analytics Rule 1"),
 *                             Map.entry("kind", "AnalyticsRule"),
 *                             Map.entry("parentId", "[resourceId('Microsoft.SecurityInsights/AlertRuleTemplates', 8365ebfe-a381-45b7-ad08-7d818070e11f)]"),
 *                             Map.entry("source", Map.ofEntries(
 *                                 Map.entry("kind", "Solution"),
 *                                 Map.entry("name", "str"),
 *                                 Map.entry("sourceId", "str.azure-sentinel-solution-str")
 *                             )),
 *                             Map.entry("support", Map.ofEntries(
 *                                 Map.entry("email", "support@microsoft.com"),
 *                                 Map.entry("link", "https://support.microsoft.com/"),
 *                                 Map.entry("name", "Microsoft Corporation"),
 *                                 Map.entry("tier", "Microsoft")
 *                             )),
 *                             Map.entry("version", "1.0.0")
 *                         )),
 *                         Map.entry("type", "Microsoft.OperationalInsights/workspaces/providers/metadata")
 *                     ))
 *             ))
 *             .packageId("str.azure-sentinel-solution-str")
 *             .packageKind("Solution")
 *             .packageName("str")
 *             .resourceGroupName("myRg")
 *             .source(MetadataSourceArgs.builder()
 *                 .kind("Solution")
 *                 .name("str")
 *                 .sourceId("str.azure-sentinel-solution-str")
 *                 .build())
 *             .support(MetadataSupportArgs.builder()
 *                 .email("support@microsoft.com")
 *                 .link("https://support.microsoft.com/")
 *                 .name("Microsoft Corporation")
 *                 .tier("Microsoft")
 *                 .build())
 *             .templateId("str.azure-sentinel-solution-str")
 *             .version("1.0.1")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ContentTemplate azuresentinel.azure-sentinel-solution-ciscoumbrella /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}
 * ```
 * @property author The creator of the content item.
 * @property categories Categories for the item
 * @property contentId Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
 * @property contentKind The kind of content the template is for.
 * @property contentSchemaVersion Schema version of the content. Can be used to distinguish between different flow based on the schema version
 * @property customVersion The custom version of the content. A optional free text
 * @property dependencies Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
 * @property displayName The display name of the template
 * @property firstPublishDate first publish date content item
 * @property icon the icon identifier. this id can later be fetched from the content metadata
 * @property lastPublishDate last publish date for the content item
 * @property mainTemplate The JSON of the ARM template to deploy active content
 * @property packageId the package Id contains this template
 * @property packageKind the packageKind of the package contains this template
 * @property packageName the name of the package contains this template
 * @property previewImages preview image file names. These will be taken from the solution artifacts
 * @property previewImagesDark preview image file names. These will be taken from the solution artifacts. used for dark theme support
 * @property providers Providers for the content item
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source Source of the content.  This is where/how it was created.
 * @property support Support information for the template - type, name, contact information
 * @property templateId template Id
 * @property threatAnalysisTactics the tactics the resource covers
 * @property threatAnalysisTechniques the techniques the resource covers, these have to be aligned with the tactics being used
 * @property version Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks
 * @property workspaceName The name of the workspace.
 */
public data class ContentTemplateArgs(
    public val author: Output<MetadataAuthorArgs>? = null,
    public val categories: Output<MetadataCategoriesArgs>? = null,
    public val contentId: Output<String>? = null,
    public val contentKind: Output<Either<String, Kind>>? = null,
    public val contentSchemaVersion: Output<String>? = null,
    public val customVersion: Output<String>? = null,
    public val dependencies: Output<MetadataDependenciesArgs>? = null,
    public val displayName: Output<String>? = null,
    public val firstPublishDate: Output<String>? = null,
    public val icon: Output<String>? = null,
    public val lastPublishDate: Output<String>? = null,
    public val mainTemplate: Output<Any>? = null,
    public val packageId: Output<String>? = null,
    public val packageKind: Output<Either<String, PackageKind>>? = null,
    public val packageName: Output<String>? = null,
    public val previewImages: Output<List<String>>? = null,
    public val previewImagesDark: Output<List<String>>? = null,
    public val providers: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<MetadataSourceArgs>? = null,
    public val support: Output<MetadataSupportArgs>? = null,
    public val templateId: Output<String>? = null,
    public val threatAnalysisTactics: Output<List<String>>? = null,
    public val threatAnalysisTechniques: Output<List<String>>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ContentTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ContentTemplateArgs =
        com.pulumi.azurenative.securityinsights.ContentTemplateArgs.builder()
            .author(author?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .categories(categories?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contentId(contentId?.applyValue({ args0 -> args0 }))
            .contentKind(
                contentKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .contentSchemaVersion(contentSchemaVersion?.applyValue({ args0 -> args0 }))
            .customVersion(customVersion?.applyValue({ args0 -> args0 }))
            .dependencies(dependencies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .firstPublishDate(firstPublishDate?.applyValue({ args0 -> args0 }))
            .icon(icon?.applyValue({ args0 -> args0 }))
            .lastPublishDate(lastPublishDate?.applyValue({ args0 -> args0 }))
            .mainTemplate(mainTemplate?.applyValue({ args0 -> args0 }))
            .packageId(packageId?.applyValue({ args0 -> args0 }))
            .packageKind(
                packageKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .previewImages(previewImages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .previewImagesDark(previewImagesDark?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .providers(providers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .support(support?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .threatAnalysisTactics(threatAnalysisTactics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .threatAnalysisTechniques(
                threatAnalysisTechniques?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentTemplateArgs].
 */
@PulumiTagMarker
public class ContentTemplateArgsBuilder internal constructor() {
    private var author: Output<MetadataAuthorArgs>? = null

    private var categories: Output<MetadataCategoriesArgs>? = null

    private var contentId: Output<String>? = null

    private var contentKind: Output<Either<String, Kind>>? = null

    private var contentSchemaVersion: Output<String>? = null

    private var customVersion: Output<String>? = null

    private var dependencies: Output<MetadataDependenciesArgs>? = null

    private var displayName: Output<String>? = null

    private var firstPublishDate: Output<String>? = null

    private var icon: Output<String>? = null

    private var lastPublishDate: Output<String>? = null

    private var mainTemplate: Output<Any>? = null

    private var packageId: Output<String>? = null

    private var packageKind: Output<Either<String, PackageKind>>? = null

    private var packageName: Output<String>? = null

    private var previewImages: Output<List<String>>? = null

    private var previewImagesDark: Output<List<String>>? = null

    private var providers: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<MetadataSourceArgs>? = null

    private var support: Output<MetadataSupportArgs>? = null

    private var templateId: Output<String>? = null

    private var threatAnalysisTactics: Output<List<String>>? = null

    private var threatAnalysisTechniques: Output<List<String>>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The creator of the content item.
     */
    @JvmName("pixvfekprtgxdgvf")
    public suspend fun author(`value`: Output<MetadataAuthorArgs>) {
        this.author = value
    }

    /**
     * @param value Categories for the item
     */
    @JvmName("nktxetpudgskglrp")
    public suspend fun categories(`value`: Output<MetadataCategoriesArgs>) {
        this.categories = value
    }

    /**
     * @param value Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
     */
    @JvmName("bgbwljjvcjrbcxso")
    public suspend fun contentId(`value`: Output<String>) {
        this.contentId = value
    }

    /**
     * @param value The kind of content the template is for.
     */
    @JvmName("bhrauhyifroanyqj")
    public suspend fun contentKind(`value`: Output<Either<String, Kind>>) {
        this.contentKind = value
    }

    /**
     * @param value Schema version of the content. Can be used to distinguish between different flow based on the schema version
     */
    @JvmName("pepmhufcoxnivpax")
    public suspend fun contentSchemaVersion(`value`: Output<String>) {
        this.contentSchemaVersion = value
    }

    /**
     * @param value The custom version of the content. A optional free text
     */
    @JvmName("nljjectpkcekpnww")
    public suspend fun customVersion(`value`: Output<String>) {
        this.customVersion = value
    }

    /**
     * @param value Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    @JvmName("lmtrbmjnldqljlht")
    public suspend fun dependencies(`value`: Output<MetadataDependenciesArgs>) {
        this.dependencies = value
    }

    /**
     * @param value The display name of the template
     */
    @JvmName("mgdyunsnvwmbcoyp")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value first publish date content item
     */
    @JvmName("ipwbkhnysdxsugld")
    public suspend fun firstPublishDate(`value`: Output<String>) {
        this.firstPublishDate = value
    }

    /**
     * @param value the icon identifier. this id can later be fetched from the content metadata
     */
    @JvmName("xuhlgcsqqfgryidb")
    public suspend fun icon(`value`: Output<String>) {
        this.icon = value
    }

    /**
     * @param value last publish date for the content item
     */
    @JvmName("sqgtwvdkgeooclws")
    public suspend fun lastPublishDate(`value`: Output<String>) {
        this.lastPublishDate = value
    }

    /**
     * @param value The JSON of the ARM template to deploy active content
     */
    @JvmName("xbhejbqtdpjomuuj")
    public suspend fun mainTemplate(`value`: Output<Any>) {
        this.mainTemplate = value
    }

    /**
     * @param value the package Id contains this template
     */
    @JvmName("kqqyvpvtxoondmew")
    public suspend fun packageId(`value`: Output<String>) {
        this.packageId = value
    }

    /**
     * @param value the packageKind of the package contains this template
     */
    @JvmName("msclecpymwlwaqtd")
    public suspend fun packageKind(`value`: Output<Either<String, PackageKind>>) {
        this.packageKind = value
    }

    /**
     * @param value the name of the package contains this template
     */
    @JvmName("kcewenficrlesujx")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("wngsqpucvgudybfn")
    public suspend fun previewImages(`value`: Output<List<String>>) {
        this.previewImages = value
    }

    @JvmName("xpyviqdsxxnkyowi")
    public suspend fun previewImages(vararg values: Output<String>) {
        this.previewImages = Output.all(values.asList())
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("rkjkhudoixwupoms")
    public suspend fun previewImages(values: List<Output<String>>) {
        this.previewImages = Output.all(values)
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("oofytkwfqlifffsj")
    public suspend fun previewImagesDark(`value`: Output<List<String>>) {
        this.previewImagesDark = value
    }

    @JvmName("oarkxjrdywiskefg")
    public suspend fun previewImagesDark(vararg values: Output<String>) {
        this.previewImagesDark = Output.all(values.asList())
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("xsyneiwimdchtnkb")
    public suspend fun previewImagesDark(values: List<Output<String>>) {
        this.previewImagesDark = Output.all(values)
    }

    /**
     * @param value Providers for the content item
     */
    @JvmName("wjsfxgyydshmgpuk")
    public suspend fun providers(`value`: Output<List<String>>) {
        this.providers = value
    }

    @JvmName("wftcomvsnggcjhdb")
    public suspend fun providers(vararg values: Output<String>) {
        this.providers = Output.all(values.asList())
    }

    /**
     * @param values Providers for the content item
     */
    @JvmName("hinwdcbpbvrfegae")
    public suspend fun providers(values: List<Output<String>>) {
        this.providers = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fajxsccllosyksle")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source of the content.  This is where/how it was created.
     */
    @JvmName("slsfjslalvpjpakn")
    public suspend fun source(`value`: Output<MetadataSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Support information for the template - type, name, contact information
     */
    @JvmName("bvigikspaefmqgjd")
    public suspend fun support(`value`: Output<MetadataSupportArgs>) {
        this.support = value
    }

    /**
     * @param value template Id
     */
    @JvmName("dqovkgcfjoqcfsni")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value the tactics the resource covers
     */
    @JvmName("elvpuufotuvdyvli")
    public suspend fun threatAnalysisTactics(`value`: Output<List<String>>) {
        this.threatAnalysisTactics = value
    }

    @JvmName("rlekheclydhwamfg")
    public suspend fun threatAnalysisTactics(vararg values: Output<String>) {
        this.threatAnalysisTactics = Output.all(values.asList())
    }

    /**
     * @param values the tactics the resource covers
     */
    @JvmName("tdsphppavojbeexl")
    public suspend fun threatAnalysisTactics(values: List<Output<String>>) {
        this.threatAnalysisTactics = Output.all(values)
    }

    /**
     * @param value the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("agckyagopvxjckqm")
    public suspend fun threatAnalysisTechniques(`value`: Output<List<String>>) {
        this.threatAnalysisTechniques = value
    }

    @JvmName("ybcehxrwfjiepfpj")
    public suspend fun threatAnalysisTechniques(vararg values: Output<String>) {
        this.threatAnalysisTechniques = Output.all(values.asList())
    }

    /**
     * @param values the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("ygvefrrmwkmqbuih")
    public suspend fun threatAnalysisTechniques(values: List<Output<String>>) {
        this.threatAnalysisTechniques = Output.all(values)
    }

    /**
     * @param value Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks
     */
    @JvmName("nrkgylnklncfvpui")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("eorrwcpivuhctqbg")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The creator of the content item.
     */
    @JvmName("mcvlisxlvjridcbg")
    public suspend fun author(`value`: MetadataAuthorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.author = mapped
    }

    /**
     * @param argument The creator of the content item.
     */
    @JvmName("cycidvtnoeijtcvd")
    public suspend fun author(argument: suspend MetadataAuthorArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataAuthorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.author = mapped
    }

    /**
     * @param value Categories for the item
     */
    @JvmName("euacgulymqacivjj")
    public suspend fun categories(`value`: MetadataCategoriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param argument Categories for the item
     */
    @JvmName("wucdpsmnykfwifaj")
    public suspend fun categories(argument: suspend MetadataCategoriesArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataCategoriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param value Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
     */
    @JvmName("dfxwcfoyhorqfkee")
    public suspend fun contentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentId = mapped
    }

    /**
     * @param value The kind of content the template is for.
     */
    @JvmName("vxbxflvdcdydhsym")
    public suspend fun contentKind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKind = mapped
    }

    /**
     * @param value The kind of content the template is for.
     */
    @JvmName("itqggmiudjcerfoa")
    public fun contentKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKind = mapped
    }

    /**
     * @param value The kind of content the template is for.
     */
    @JvmName("cxccnjlgawxgdvab")
    public fun contentKind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKind = mapped
    }

    /**
     * @param value Schema version of the content. Can be used to distinguish between different flow based on the schema version
     */
    @JvmName("qyliupbtldrlplhp")
    public suspend fun contentSchemaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentSchemaVersion = mapped
    }

    /**
     * @param value The custom version of the content. A optional free text
     */
    @JvmName("bukjvgcqvecdpjyu")
    public suspend fun customVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customVersion = mapped
    }

    /**
     * @param value Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    @JvmName("mlwjcvtvktoinfhb")
    public suspend fun dependencies(`value`: MetadataDependenciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param argument Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    @JvmName("lpuvkppdlyaswxbn")
    public suspend fun dependencies(argument: suspend MetadataDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataDependenciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependencies = mapped
    }

    /**
     * @param value The display name of the template
     */
    @JvmName("kohhxgpmwasbboru")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value first publish date content item
     */
    @JvmName("iwbhoqyerxpxbeas")
    public suspend fun firstPublishDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstPublishDate = mapped
    }

    /**
     * @param value the icon identifier. this id can later be fetched from the content metadata
     */
    @JvmName("vwojugvsitbuwyiv")
    public suspend fun icon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icon = mapped
    }

    /**
     * @param value last publish date for the content item
     */
    @JvmName("pawyclnfhfhokbex")
    public suspend fun lastPublishDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastPublishDate = mapped
    }

    /**
     * @param value The JSON of the ARM template to deploy active content
     */
    @JvmName("opyjyjaoxqgroamb")
    public suspend fun mainTemplate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mainTemplate = mapped
    }

    /**
     * @param value the package Id contains this template
     */
    @JvmName("raqdpcfyabclysln")
    public suspend fun packageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageId = mapped
    }

    /**
     * @param value the packageKind of the package contains this template
     */
    @JvmName("pxlvyclnviecryla")
    public suspend fun packageKind(`value`: Either<String, PackageKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageKind = mapped
    }

    /**
     * @param value the packageKind of the package contains this template
     */
    @JvmName("sidfychqqwjsynps")
    public fun packageKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PackageKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageKind = mapped
    }

    /**
     * @param value the packageKind of the package contains this template
     */
    @JvmName("hacbvfaldqffktjj")
    public fun packageKind(`value`: PackageKind) {
        val toBeMapped = Either.ofRight<String, PackageKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageKind = mapped
    }

    /**
     * @param value the name of the package contains this template
     */
    @JvmName("avsklkpkvcnhhtst")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("fnxxgfjfqyjggyay")
    public suspend fun previewImages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.previewImages = mapped
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts
     */
    @JvmName("nofwjkbvxcerhvnc")
    public suspend fun previewImages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.previewImages = mapped
    }

    /**
     * @param value preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("lvfkxdewdprjolll")
    public suspend fun previewImagesDark(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.previewImagesDark = mapped
    }

    /**
     * @param values preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    @JvmName("dcmvhqdhlkkivtdv")
    public suspend fun previewImagesDark(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.previewImagesDark = mapped
    }

    /**
     * @param value Providers for the content item
     */
    @JvmName("swhxrgfvcfkdbdlt")
    public suspend fun providers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param values Providers for the content item
     */
    @JvmName("smqbmmiwfpdelvei")
    public suspend fun providers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ceeugasamnpawskk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source of the content.  This is where/how it was created.
     */
    @JvmName("xuvssenmwqxegieq")
    public suspend fun source(`value`: MetadataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Source of the content.  This is where/how it was created.
     */
    @JvmName("cgwinxflvdqdkvre")
    public suspend fun source(argument: suspend MetadataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Support information for the template - type, name, contact information
     */
    @JvmName("geflinwdfjsavwro")
    public suspend fun support(`value`: MetadataSupportArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.support = mapped
    }

    /**
     * @param argument Support information for the template - type, name, contact information
     */
    @JvmName("fpqaoxijdxaxcqld")
    public suspend fun support(argument: suspend MetadataSupportArgsBuilder.() -> Unit) {
        val toBeMapped = MetadataSupportArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.support = mapped
    }

    /**
     * @param value template Id
     */
    @JvmName("haeectyvnbrvvvfi")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value the tactics the resource covers
     */
    @JvmName("tmavnqjkqxhnkujq")
    public suspend fun threatAnalysisTactics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisTactics = mapped
    }

    /**
     * @param values the tactics the resource covers
     */
    @JvmName("opldsqlrtiuwppcx")
    public suspend fun threatAnalysisTactics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatAnalysisTactics = mapped
    }

    /**
     * @param value the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("etgmeqhnhjmojpwk")
    public suspend fun threatAnalysisTechniques(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisTechniques = mapped
    }

    /**
     * @param values the techniques the resource covers, these have to be aligned with the tactics being used
     */
    @JvmName("fuuqjmtukodhnubf")
    public suspend fun threatAnalysisTechniques(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatAnalysisTechniques = mapped
    }

    /**
     * @param value Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM metadata best practices.  Can also be any string, but then we cannot guarantee any version checks
     */
    @JvmName("kdnjwltiqyuxwtqg")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("bmsuvetlrjkuaith")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ContentTemplateArgs = ContentTemplateArgs(
        author = author,
        categories = categories,
        contentId = contentId,
        contentKind = contentKind,
        contentSchemaVersion = contentSchemaVersion,
        customVersion = customVersion,
        dependencies = dependencies,
        displayName = displayName,
        firstPublishDate = firstPublishDate,
        icon = icon,
        lastPublishDate = lastPublishDate,
        mainTemplate = mainTemplate,
        packageId = packageId,
        packageKind = packageKind,
        packageName = packageName,
        previewImages = previewImages,
        previewImagesDark = previewImagesDark,
        providers = providers,
        resourceGroupName = resourceGroupName,
        source = source,
        support = support,
        templateId = templateId,
        threatAnalysisTactics = threatAnalysisTactics,
        threatAnalysisTechniques = threatAnalysisTechniques,
        version = version,
        workspaceName = workspaceName,
    )
}
