@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EyesOn].
 */
@PulumiTagMarker
public class EyesOnResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EyesOnArgs = EyesOnArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EyesOnArgsBuilder.() -> Unit) {
        val builder = EyesOnArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EyesOn {
        val builtJavaResource = com.pulumi.azurenative.securityinsights.EyesOn(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EyesOn(builtJavaResource)
    }
}

/**
 * Settings with single toggle.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### Update EyesOn settings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eyesOn = new AzureNative.SecurityInsights.EyesOn("eyesOn", new()
 *     {
 *         Kind = "EyesOn",
 *         ResourceGroupName = "myRg",
 *         SettingsName = "EyesOn",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewEyesOn(ctx, "eyesOn", &securityinsights.EyesOnArgs{
 * 			Kind:              pulumi.String("EyesOn"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			SettingsName:      pulumi.String("EyesOn"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.EyesOn;
 * import com.pulumi.azurenative.securityinsights.EyesOnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eyesOn = new EyesOn("eyesOn", EyesOnArgs.builder()
 *             .kind("EyesOn")
 *             .resourceGroupName("myRg")
 *             .settingsName("EyesOn")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:EyesOn EyesOn /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}
 * ```
 */
public class EyesOn internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.EyesOn,
) : KotlinCustomResource(javaResource, EyesOnMapper) {
    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Determines whether the setting is enable or disabled.
     */
    public val isEnabled: Output<Boolean>
        get() = javaResource.isEnabled().applyValue({ args0 -> args0 })

    /**
     * The kind of the setting
     * Expected value is 'EyesOn'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EyesOnMapper : ResourceMapper<EyesOn> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.EyesOn::class == javaResource::class

    override fun map(javaResource: Resource): EyesOn = EyesOn(
        javaResource as
            com.pulumi.azurenative.securityinsights.EyesOn,
    )
}

/**
 * @see [EyesOn].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EyesOn].
 */
public suspend fun eyesOn(name: String, block: suspend EyesOnResourceBuilder.() -> Unit): EyesOn {
    val builder = EyesOnResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EyesOn].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eyesOn(name: String): EyesOn {
    val builder = EyesOnResourceBuilder()
    builder.name(name)
    return builder.build()
}
