@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents Fusion alert rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates a Fusion alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fusionAlertRule = new AzureNative.SecurityInsights.FusionAlertRule("fusionAlertRule", new()
 *     {
 *         AlertRuleTemplateName = "f71aba3d-28fb-450b-b192-4e76a83015c8",
 *         Enabled = true,
 *         Kind = "Fusion",
 *         ResourceGroupName = "myRg",
 *         RuleId = "myFirstFusionRule",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFusionAlertRule(ctx, "fusionAlertRule", &securityinsights.FusionAlertRuleArgs{
 * 			AlertRuleTemplateName: pulumi.String("f71aba3d-28fb-450b-b192-4e76a83015c8"),
 * 			Enabled:               pulumi.Bool(true),
 * 			Kind:                  pulumi.String("Fusion"),
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			RuleId:                pulumi.String("myFirstFusionRule"),
 * 			WorkspaceName:         pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRule;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fusionAlertRule = new FusionAlertRule("fusionAlertRule", FusionAlertRuleArgs.builder()
 *             .alertRuleTemplateName("f71aba3d-28fb-450b-b192-4e76a83015c8")
 *             .enabled(true)
 *             .kind("Fusion")
 *             .resourceGroupName("myRg")
 *             .ruleId("myFirstFusionRule")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a MicrosoftSecurityIncidentCreation rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fusionAlertRule = new AzureNative.SecurityInsights.FusionAlertRule("fusionAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "microsoftSecurityIncidentCreationRuleExample",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFusionAlertRule(ctx, "fusionAlertRule", &securityinsights.FusionAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("microsoftSecurityIncidentCreationRuleExample"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRule;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fusionAlertRule = new FusionAlertRule("fusionAlertRule", FusionAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("microsoftSecurityIncidentCreationRuleExample")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a Scheduled alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fusionAlertRule = new AzureNative.SecurityInsights.FusionAlertRule("fusionAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFusionAlertRule(ctx, "fusionAlertRule", &securityinsights.FusionAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRule;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fusionAlertRule = new FusionAlertRule("fusionAlertRule", FusionAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:FusionAlertRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}
 * ```
 * @property alertRuleTemplateName The Name of the alert rule template used to create this rule.
 * @property enabled Determines whether this alert rule is enabled or disabled.
 * @property kind The kind of the alert rule
 * Expected value is 'Fusion'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId Alert rule ID
 * @property workspaceName The name of the workspace.
 */
public data class FusionAlertRuleArgs(
    public val alertRuleTemplateName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs =
        com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs.builder()
            .alertRuleTemplateName(alertRuleTemplateName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FusionAlertRuleArgs].
 */
@PulumiTagMarker
public class FusionAlertRuleArgsBuilder internal constructor() {
    private var alertRuleTemplateName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The Name of the alert rule template used to create this rule.
     */
    @JvmName("cifyuotqhfiqtajd")
    public suspend fun alertRuleTemplateName(`value`: Output<String>) {
        this.alertRuleTemplateName = value
    }

    /**
     * @param value Determines whether this alert rule is enabled or disabled.
     */
    @JvmName("wooylfdwrtqfcigu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The kind of the alert rule
     * Expected value is 'Fusion'.
     */
    @JvmName("grwuahpuoykcfknk")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("htshlopvsrgaewqi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("txywaohtntsnrcme")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gdaxlaotjtbsnmpo")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The Name of the alert rule template used to create this rule.
     */
    @JvmName("onsmoslgvasgexan")
    public suspend fun alertRuleTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertRuleTemplateName = mapped
    }

    /**
     * @param value Determines whether this alert rule is enabled or disabled.
     */
    @JvmName("ncfdnunpbqiliedf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The kind of the alert rule
     * Expected value is 'Fusion'.
     */
    @JvmName("iekiftwrhukrpety")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ykawhqvrqmlfgabs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("dgjmqmtslquaibpt")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("vafodhcpglrsfygn")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FusionAlertRuleArgs = FusionAlertRuleArgs(
        alertRuleTemplateName = alertRuleTemplateName,
        enabled = enabled,
        kind = kind,
        resourceGroupName = resourceGroupName,
        ruleId = ruleId,
        workspaceName = workspaceName,
    )
}
