@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin as clientInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IncidentTask].
 */
@PulumiTagMarker
public class IncidentTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IncidentTaskArgs = IncidentTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IncidentTaskArgsBuilder.() -> Unit) {
        val builder = IncidentTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IncidentTask {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.IncidentTask(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IncidentTask(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### IncidentTasks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incidentTask = new AzureNative.SecurityInsights.IncidentTask("incidentTask", new()
 *     {
 *         Description = "Task description",
 *         IncidentId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         IncidentTaskId = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         ResourceGroupName = "myRg",
 *         Status = AzureNative.SecurityInsights.IncidentTaskStatus.New,
 *         Title = "Task title",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncidentTask(ctx, "incidentTask", &securityinsights.IncidentTaskArgs{
 * 			Description:       pulumi.String("Task description"),
 * 			IncidentId:        pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			IncidentTaskId:    pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Status:            pulumi.String(securityinsights.IncidentTaskStatusNew),
 * 			Title:             pulumi.String("Task title"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.IncidentTask;
 * import com.pulumi.azurenative.securityinsights.IncidentTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incidentTask = new IncidentTask("incidentTask", IncidentTaskArgs.builder()
 *             .description("Task description")
 *             .incidentId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .incidentTaskId("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .resourceGroupName("myRg")
 *             .status("New")
 *             .title("Task title")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:IncidentTask 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}
 * ```
 */
public class IncidentTask internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.IncidentTask,
) : KotlinCustomResource(javaResource, IncidentTaskMapper) {
    /**
     * Information on the client (user or application) that made some action
     */
    public val createdBy: Output<ClientInfoResponse>?
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clientInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time the task was created
     */
    public val createdTimeUtc: Output<String>
        get() = javaResource.createdTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The description of the task
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information on the client (user or application) that made some action
     */
    public val lastModifiedBy: Output<ClientInfoResponse>?
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clientInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The last time the task was updated
     */
    public val lastModifiedTimeUtc: Output<String>
        get() = javaResource.lastModifiedTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The title of the task
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IncidentTaskMapper : ResourceMapper<IncidentTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.IncidentTask::class == javaResource::class

    override fun map(javaResource: Resource): IncidentTask = IncidentTask(
        javaResource as
            com.pulumi.azurenative.securityinsights.IncidentTask,
    )
}

/**
 * @see [IncidentTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IncidentTask].
 */
public suspend fun incidentTask(
    name: String,
    block: suspend IncidentTaskResourceBuilder.() -> Unit,
): IncidentTask {
    val builder = IncidentTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IncidentTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun incidentTask(name: String): IncidentTask {
    val builder = IncidentTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
