@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.OfficeDataConnectorDataTypesArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.OfficeDataConnectorDataTypesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents office data connector.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates an Office365 data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var officeDataConnector = new AzureNative.SecurityInsights.OfficeDataConnector("officeDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         DataTypes = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesArgs
 *         {
 *             Exchange = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesExchangeArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *             SharePoint = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesSharePointArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *             Teams = new AzureNative.SecurityInsights.Inputs.OfficeDataConnectorDataTypesTeamsArgs
 *             {
 *                 State = AzureNative.SecurityInsights.DataTypeState.Enabled,
 *             },
 *         },
 *         Kind = "Office365",
 *         ResourceGroupName = "myRg",
 *         TenantId = "2070ecc9-b4d5-4ae4-adaa-936fa1954fa8",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewOfficeDataConnector(ctx, "officeDataConnector", &securityinsights.OfficeDataConnectorArgs{
 * 			DataConnectorId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			DataTypes: &securityinsights.OfficeDataConnectorDataTypesArgs{
 * 				Exchange: &securityinsights.OfficeDataConnectorDataTypesExchangeArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 				SharePoint: &securityinsights.OfficeDataConnectorDataTypesSharePointArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 				Teams: &securityinsights.OfficeDataConnectorDataTypesTeamsArgs{
 * 					State: pulumi.String(securityinsights.DataTypeStateEnabled),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("Office365"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			TenantId:          pulumi.String("2070ecc9-b4d5-4ae4-adaa-936fa1954fa8"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnector;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesExchangeArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesSharePointArgs;
 * import com.pulumi.azurenative.securityinsights.inputs.OfficeDataConnectorDataTypesTeamsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var officeDataConnector = new OfficeDataConnector("officeDataConnector", OfficeDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .dataTypes(OfficeDataConnectorDataTypesArgs.builder()
 *                 .exchange(OfficeDataConnectorDataTypesExchangeArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .sharePoint(OfficeDataConnectorDataTypesSharePointArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .teams(OfficeDataConnectorDataTypesTeamsArgs.builder()
 *                     .state("Enabled")
 *                     .build())
 *                 .build())
 *             .kind("Office365")
 *             .resourceGroupName("myRg")
 *             .tenantId("2070ecc9-b4d5-4ae4-adaa-936fa1954fa8")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates an Threat Intelligence Platform data connector.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var officeDataConnector = new AzureNative.SecurityInsights.OfficeDataConnector("officeDataConnector", new()
 *     {
 *         DataConnectorId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewOfficeDataConnector(ctx, "officeDataConnector", &securityinsights.OfficeDataConnectorArgs{
 * 			DataConnectorId:   pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnector;
 * import com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var officeDataConnector = new OfficeDataConnector("officeDataConnector", OfficeDataConnectorArgs.builder()
 *             .dataConnectorId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:OfficeDataConnector 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectors/{dataConnectorId}
 * ```
 * @property dataConnectorId Connector ID
 * @property dataTypes The available data types for the connector.
 * @property kind The kind of the data connector
 * Expected value is 'Office365'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tenantId The tenant id to connect to, and get the data from.
 * @property workspaceName The name of the workspace.
 */
public data class OfficeDataConnectorArgs(
    public val dataConnectorId: Output<String>? = null,
    public val dataTypes: Output<OfficeDataConnectorDataTypesArgs>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs =
        com.pulumi.azurenative.securityinsights.OfficeDataConnectorArgs.builder()
            .dataConnectorId(dataConnectorId?.applyValue({ args0 -> args0 }))
            .dataTypes(dataTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OfficeDataConnectorArgs].
 */
@PulumiTagMarker
public class OfficeDataConnectorArgsBuilder internal constructor() {
    private var dataConnectorId: Output<String>? = null

    private var dataTypes: Output<OfficeDataConnectorDataTypesArgs>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Connector ID
     */
    @JvmName("ylvvrfrysselhlts")
    public suspend fun dataConnectorId(`value`: Output<String>) {
        this.dataConnectorId = value
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("bjhwtvrobjvyqjsu")
    public suspend fun dataTypes(`value`: Output<OfficeDataConnectorDataTypesArgs>) {
        this.dataTypes = value
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'Office365'.
     */
    @JvmName("bfgvlishcqxiuruk")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dtofqrucjqrgtrdm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tenant id to connect to, and get the data from.
     */
    @JvmName("ogrbhdbftsfloptj")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("trvbwhbxjlnupndf")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Connector ID
     */
    @JvmName("dfpulmawmcxcfnbn")
    public suspend fun dataConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectorId = mapped
    }

    /**
     * @param value The available data types for the connector.
     */
    @JvmName("elnsxfruonvuovfn")
    public suspend fun dataTypes(`value`: OfficeDataConnectorDataTypesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param argument The available data types for the connector.
     */
    @JvmName("ukqawuohqyvibbap")
    public suspend fun dataTypes(argument: suspend OfficeDataConnectorDataTypesArgsBuilder.() -> Unit) {
        val toBeMapped = OfficeDataConnectorDataTypesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataTypes = mapped
    }

    /**
     * @param value The kind of the data connector
     * Expected value is 'Office365'.
     */
    @JvmName("dskbyjfaokihbklj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ywuflupasfhmfqyt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tenant id to connect to, and get the data from.
     */
    @JvmName("tmlnxaeworcskves")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("fdygrpuscpguwhuq")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): OfficeDataConnectorArgs = OfficeDataConnectorArgs(
        dataConnectorId = dataConnectorId,
        dataTypes = dataTypes,
        kind = kind,
        resourceGroupName = resourceGroupName,
        tenantId = tenantId,
        workspaceName = workspaceName,
    )
}
