@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse.Companion.toKotlin as watchlistUserInfoResponseToKotlin

/**
 * Builder for [WatchlistItem].
 */
@PulumiTagMarker
public class WatchlistItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WatchlistItemArgs = WatchlistItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WatchlistItemArgsBuilder.() -> Unit) {
        val builder = WatchlistItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WatchlistItem {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.WatchlistItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WatchlistItem(builtJavaResource)
    }
}

/**
 * Represents a Watchlist Item in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-04-01, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview, 2024-01-01-preview, 2024-03-01.
 * ## Example Usage
 * ### Create or update a watchlist item.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watchlistItem = new AzureNative.SecurityInsights.WatchlistItem("watchlistItem", new()
 *     {
 *         ItemsKeyValue = new Dictionary<string, object?>
 *         {
 *             ["Business tier"] = "10.0.2.0/24",
 *             ["Data tier"] = "10.0.2.0/24",
 *             ["Gateway subnet"] = "10.0.255.224/27",
 *             ["Private DMZ in"] = "10.0.0.0/27",
 *             ["Public DMZ out"] = "10.0.0.96/27",
 *             ["Web Tier"] = "10.0.1.0/24",
 *         },
 *         ResourceGroupName = "myRg",
 *         WatchlistAlias = "highValueAsset",
 *         WatchlistItemId = "82ba292c-dc97-4dfc-969d-d4dd9e666842",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWatchlistItem(ctx, "watchlistItem", &securityinsights.WatchlistItemArgs{
 * 			ItemsKeyValue: pulumi.Any(map[string]interface{}{
 * 				"Business tier":  "10.0.2.0/24",
 * 				"Data tier":      "10.0.2.0/24",
 * 				"Gateway subnet": "10.0.255.224/27",
 * 				"Private DMZ in": "10.0.0.0/27",
 * 				"Public DMZ out": "10.0.0.96/27",
 * 				"Web Tier":       "10.0.1.0/24",
 * 			}),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WatchlistAlias:    pulumi.String("highValueAsset"),
 * 			WatchlistItemId:   pulumi.String("82ba292c-dc97-4dfc-969d-d4dd9e666842"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WatchlistItem;
 * import com.pulumi.azurenative.securityinsights.WatchlistItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watchlistItem = new WatchlistItem("watchlistItem", WatchlistItemArgs.builder()
 *             .itemsKeyValue(Map.ofEntries(
 *                 Map.entry("Business tier", "10.0.2.0/24"),
 *                 Map.entry("Data tier", "10.0.2.0/24"),
 *                 Map.entry("Gateway subnet", "10.0.255.224/27"),
 *                 Map.entry("Private DMZ in", "10.0.0.0/27"),
 *                 Map.entry("Public DMZ out", "10.0.0.96/27"),
 *                 Map.entry("Web Tier", "10.0.1.0/24")
 *             ))
 *             .resourceGroupName("myRg")
 *             .watchlistAlias("highValueAsset")
 *             .watchlistItemId("82ba292c-dc97-4dfc-969d-d4dd9e666842")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WatchlistItem myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/watchlists/{watchlistAlias}/watchlistItems/{watchlistItemId}
 * ```
 */
public class WatchlistItem internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.WatchlistItem,
) : KotlinCustomResource(javaResource, WatchlistItemMapper) {
    /**
     * The time the watchlist item was created
     */
    public val created: Output<String>?
        get() = javaResource.created().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes a user that created the watchlist item
     */
    public val createdBy: Output<WatchlistUserInfoResponse>?
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    watchlistUserInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * key-value pairs for a watchlist item entity mapping
     */
    public val entityMapping: Output<Any>?
        get() = javaResource.entityMapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A flag that indicates if the watchlist item is deleted or not
     */
    public val isDeleted: Output<Boolean>?
        get() = javaResource.isDeleted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * key-value pairs for a watchlist item
     */
    public val itemsKeyValue: Output<Any>
        get() = javaResource.itemsKeyValue().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tenantId to which the watchlist item belongs to
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The last time the watchlist item was updated
     */
    public val updated: Output<String>?
        get() = javaResource.updated().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes a user that updated the watchlist item
     */
    public val updatedBy: Output<WatchlistUserInfoResponse>?
        get() = javaResource.updatedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    watchlistUserInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The id (a Guid) of the watchlist item
     */
    public val watchlistItemId: Output<String>?
        get() = javaResource.watchlistItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the watchlist item
     */
    public val watchlistItemType: Output<String>?
        get() = javaResource.watchlistItemType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object WatchlistItemMapper : ResourceMapper<WatchlistItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.WatchlistItem::class == javaResource::class

    override fun map(javaResource: Resource): WatchlistItem = WatchlistItem(
        javaResource as
            com.pulumi.azurenative.securityinsights.WatchlistItem,
    )
}

/**
 * @see [WatchlistItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WatchlistItem].
 */
public suspend fun watchlistItem(
    name: String,
    block: suspend WatchlistItemResourceBuilder.() -> Unit,
): WatchlistItem {
    val builder = WatchlistItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WatchlistItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun watchlistItem(name: String): WatchlistItem {
    val builder = WatchlistItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
