@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceManagerConfiguration].
 */
@PulumiTagMarker
public class WorkspaceManagerConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceManagerConfigurationArgs = WorkspaceManagerConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceManagerConfigurationArgsBuilder.() -> Unit) {
        val builder = WorkspaceManagerConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceManagerConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.WorkspaceManagerConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceManagerConfiguration(builtJavaResource)
    }
}

/**
 * The workspace manager configuration
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Create or Update a workspace manager Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerConfiguration = new AzureNative.SecurityInsights.WorkspaceManagerConfiguration("workspaceManagerConfiguration", new()
 *     {
 *         Mode = AzureNative.SecurityInsights.Mode.Enabled,
 *         ResourceGroupName = "myRg",
 *         WorkspaceManagerConfigurationName = "default",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerConfiguration(ctx, "workspaceManagerConfiguration", &securityinsights.WorkspaceManagerConfigurationArgs{
 * 			Mode:                              pulumi.String(securityinsights.ModeEnabled),
 * 			ResourceGroupName:                 pulumi.String("myRg"),
 * 			WorkspaceManagerConfigurationName: pulumi.String("default"),
 * 			WorkspaceName:                     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerConfiguration;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerConfiguration = new WorkspaceManagerConfiguration("workspaceManagerConfiguration", WorkspaceManagerConfigurationArgs.builder()
 *             .mode("Enabled")
 *             .resourceGroupName("myRg")
 *             .workspaceManagerConfigurationName("default")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerConfigurations/{workspaceManagerConfigurationName}
 * ```
 */
public class WorkspaceManagerConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.WorkspaceManagerConfiguration,
) : KotlinCustomResource(javaResource, WorkspaceManagerConfigurationMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The current mode of the workspace manager configuration
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceManagerConfigurationMapper : ResourceMapper<WorkspaceManagerConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceManagerConfiguration =
        WorkspaceManagerConfiguration(
            javaResource as
                com.pulumi.azurenative.securityinsights.WorkspaceManagerConfiguration,
        )
}

/**
 * @see [WorkspaceManagerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceManagerConfiguration].
 */
public suspend fun workspaceManagerConfiguration(
    name: String,
    block: suspend WorkspaceManagerConfigurationResourceBuilder.() -> Unit,
): WorkspaceManagerConfiguration {
    val builder = WorkspaceManagerConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceManagerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceManagerConfiguration(name: String): WorkspaceManagerConfiguration {
    val builder = WorkspaceManagerConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
