@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The V3 alert property
 */
public enum class AlertProperty(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.AlertProperty,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.AlertProperty> {
    /**
     * Alert's link
     */
    AlertLink(com.pulumi.azurenative.securityinsights.enums.AlertProperty.AlertLink),

    /**
     * Confidence level property
     */
    ConfidenceLevel(com.pulumi.azurenative.securityinsights.enums.AlertProperty.ConfidenceLevel),

    /**
     * Confidence score
     */
    ConfidenceScore(com.pulumi.azurenative.securityinsights.enums.AlertProperty.ConfidenceScore),

    /**
     * Extended links to the alert
     */
    ExtendedLinks(com.pulumi.azurenative.securityinsights.enums.AlertProperty.ExtendedLinks),

    /**
     * Product name alert property
     */
    ProductName(com.pulumi.azurenative.securityinsights.enums.AlertProperty.ProductName),

    /**
     * Provider name alert property
     */
    ProviderName(com.pulumi.azurenative.securityinsights.enums.AlertProperty.ProviderName),

    /**
     * Product component name alert property
     */
    ProductComponentName(com.pulumi.azurenative.securityinsights.enums.AlertProperty.ProductComponentName),

    /**
     * Remediation steps alert property
     */
    RemediationSteps(com.pulumi.azurenative.securityinsights.enums.AlertProperty.RemediationSteps),

    /**
     * Techniques alert property
     */
    Techniques(com.pulumi.azurenative.securityinsights.enums.AlertProperty.Techniques),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.AlertProperty = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.AlertProperty): AlertProperty = AlertProperty.values().first { it.javaValue == javaType }
    }
}
